/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.jackson.serializer;

import com.casper.sdk.model.transaction.target.Native;
import com.casper.sdk.model.transaction.target.Session;
import com.casper.sdk.model.transaction.target.Stored;
import com.casper.sdk.model.transaction.target.TargetConstants;
import com.casper.sdk.model.transaction.target.TransactionRuntime;
import com.casper.sdk.model.transaction.target.TransactionTarget;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.syntifi.crypto.key.encdec.Hex;
import java.io.IOException;

public class TransactionTargetSerializer
extends JsonSerializer<TransactionTarget> {
    public void serialize(TransactionTarget value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value instanceof Session) {
            TransactionTargetSerializer.serializeSession((Session)value, gen);
        } else if (value instanceof Native) {
            gen.writeString("Native");
        } else if (value instanceof Stored) {
            TransactionTargetSerializer.serializeStored((Stored)value, gen);
        } else {
            throw new IllegalArgumentException("Unknown transaction target type: " + value.getClass().getName());
        }
    }

    private static void serializeStored(Stored value, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeFieldName(TargetConstants.STORED);
        gen.writeStartObject();
        gen.writeFieldName("id");
        gen.writeObject((Object)value.getId());
        if (value.getRuntime() != null) {
            gen.writeFieldName("runtime");
            gen.writeString(value.getRuntime().getJsonName());
        }
        gen.writeNumberField("transferred_value", value.getTransferredValue());
        gen.writeEndObject();
        gen.writeEndObject();
    }

    private static void serializeSession(Session value, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeFieldName(TargetConstants.SESSION);
        gen.writeStartObject();
        gen.writeBooleanField("is_install_upgrade", value.isInstallUpgrade());
        gen.writeStringField("runtime", TransactionRuntime.toJson(value.getRuntime()));
        gen.writeStringField("module_bytes", Hex.encode(value.getModuleBytes()));
        gen.writeNumberField("transferred_value", value.getTransferredValue());
        gen.writeObjectField("seed", (Object)value.getSeed());
        gen.writeEndObject();
        gen.writeEndObject();
    }
}

