/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.account;

import com.casper.sdk.model.account.ActionThresholds;
import com.casper.sdk.model.account.AssociatedKey;
import com.casper.sdk.model.contract.NamedKey;
import com.casper.sdk.model.key.AccountHashKey;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class Account {
    @JsonProperty(value="account_hash")
    private AccountHashKey hash;
    @JsonProperty(value="action_thresholds")
    private ActionThresholds deployment;
    @JsonProperty(value="associated_keys")
    private List<AssociatedKey> associatedKeys;
    @JsonProperty(value="main_purse")
    private String mainPurse;
    @JsonProperty(value="named_keys")
    private List<NamedKey> namedKeys;

    public static AccountBuilder builder() {
        return new AccountBuilder();
    }

    public AccountHashKey getHash() {
        return this.hash;
    }

    public ActionThresholds getDeployment() {
        return this.deployment;
    }

    public List<AssociatedKey> getAssociatedKeys() {
        return this.associatedKeys;
    }

    public String getMainPurse() {
        return this.mainPurse;
    }

    public List<NamedKey> getNamedKeys() {
        return this.namedKeys;
    }

    @JsonProperty(value="account_hash")
    public void setHash(AccountHashKey hash) {
        this.hash = hash;
    }

    @JsonProperty(value="action_thresholds")
    public void setDeployment(ActionThresholds deployment) {
        this.deployment = deployment;
    }

    @JsonProperty(value="associated_keys")
    public void setAssociatedKeys(List<AssociatedKey> associatedKeys) {
        this.associatedKeys = associatedKeys;
    }

    @JsonProperty(value="main_purse")
    public void setMainPurse(String mainPurse) {
        this.mainPurse = mainPurse;
    }

    @JsonProperty(value="named_keys")
    public void setNamedKeys(List<NamedKey> namedKeys) {
        this.namedKeys = namedKeys;
    }

    public Account() {
    }

    public Account(AccountHashKey hash, ActionThresholds deployment, List<AssociatedKey> associatedKeys, String mainPurse, List<NamedKey> namedKeys) {
        this.hash = hash;
        this.deployment = deployment;
        this.associatedKeys = associatedKeys;
        this.mainPurse = mainPurse;
        this.namedKeys = namedKeys;
    }

    public static class AccountBuilder {
        private AccountHashKey hash;
        private ActionThresholds deployment;
        private List<AssociatedKey> associatedKeys;
        private String mainPurse;
        private List<NamedKey> namedKeys;

        AccountBuilder() {
        }

        @JsonProperty(value="account_hash")
        public AccountBuilder hash(AccountHashKey hash) {
            this.hash = hash;
            return this;
        }

        @JsonProperty(value="action_thresholds")
        public AccountBuilder deployment(ActionThresholds deployment) {
            this.deployment = deployment;
            return this;
        }

        @JsonProperty(value="associated_keys")
        public AccountBuilder associatedKeys(List<AssociatedKey> associatedKeys) {
            this.associatedKeys = associatedKeys;
            return this;
        }

        @JsonProperty(value="main_purse")
        public AccountBuilder mainPurse(String mainPurse) {
            this.mainPurse = mainPurse;
            return this;
        }

        @JsonProperty(value="named_keys")
        public AccountBuilder namedKeys(List<NamedKey> namedKeys) {
            this.namedKeys = namedKeys;
            return this;
        }

        public Account build() {
            return new Account(this.hash, this.deployment, this.associatedKeys, this.mainPurse, this.namedKeys);
        }

        public String toString() {
            return "Account.AccountBuilder(hash=" + this.hash + ", deployment=" + this.deployment + ", associatedKeys=" + this.associatedKeys + ", mainPurse=" + this.mainPurse + ", namedKeys=" + this.namedKeys + ")";
        }
    }
}

