/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.account;

import com.casper.sdk.exception.CasperClientException;
import com.casper.sdk.model.account.AccountIdentifier;
import com.casper.sdk.model.key.PublicKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.security.NoSuchAlgorithmException;

public class PublicKeyIdentifier
implements AccountIdentifier {
    @JsonProperty(value="PublicKey")
    private PublicKey publicKey;

    @JsonCreator
    public PublicKeyIdentifier(String hexKey) {
        try {
            this.publicKey = PublicKey.fromTaggedHexString(hexKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CasperClientException("Invalid public key bytes", e);
        }
    }

    public static PublicKeyIdentifierBuilder builder() {
        return new PublicKeyIdentifierBuilder();
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @JsonProperty(value="PublicKey")
    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public PublicKeyIdentifier(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public static class PublicKeyIdentifierBuilder {
        private PublicKey publicKey;

        PublicKeyIdentifierBuilder() {
        }

        @JsonProperty(value="PublicKey")
        public PublicKeyIdentifierBuilder publicKey(PublicKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public PublicKeyIdentifier build() {
            return new PublicKeyIdentifier(this.publicKey);
        }

        public String toString() {
            return "PublicKeyIdentifier.PublicKeyIdentifierBuilder(publicKey=" + this.publicKey + ")";
        }
    }
}

