/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.bid;

import com.casper.sdk.annotation.ExcludeFromJacocoGeneratedReport;
import com.casper.sdk.model.bid.VestingSchedule;
import com.casper.sdk.model.deploy.DelegatorKind;
import com.casper.sdk.model.key.PublicKey;
import com.casper.sdk.model.uref.URef;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;

public class Delegator {
    @JsonProperty(value="validator_public_key")
    private PublicKey validatorPublicKey;
    @JsonProperty(value="delegator_kind")
    private DelegatorKind delegatorKind;
    @JsonProperty(value="vesting_schedule")
    private VestingSchedule vestingSchedule;
    @JsonProperty(value="bonding_purse")
    private URef bondingPurse;
    @JsonIgnore
    private BigInteger stakedAmount;

    @JsonProperty(value="staked_amount")
    @ExcludeFromJacocoGeneratedReport
    protected String getJsonStakedAmount() {
        return this.stakedAmount.toString(10);
    }

    @JsonProperty(value="staked_amount")
    @ExcludeFromJacocoGeneratedReport
    protected void setJsonStakedAmount(String value) {
        this.stakedAmount = new BigInteger(value, 10);
    }

    public static DelegatorBuilder builder() {
        return new DelegatorBuilder();
    }

    public PublicKey getValidatorPublicKey() {
        return this.validatorPublicKey;
    }

    public DelegatorKind getDelegatorKind() {
        return this.delegatorKind;
    }

    public VestingSchedule getVestingSchedule() {
        return this.vestingSchedule;
    }

    public URef getBondingPurse() {
        return this.bondingPurse;
    }

    public BigInteger getStakedAmount() {
        return this.stakedAmount;
    }

    @JsonProperty(value="validator_public_key")
    public void setValidatorPublicKey(PublicKey validatorPublicKey) {
        this.validatorPublicKey = validatorPublicKey;
    }

    @JsonProperty(value="delegator_kind")
    public void setDelegatorKind(DelegatorKind delegatorKind) {
        this.delegatorKind = delegatorKind;
    }

    @JsonProperty(value="vesting_schedule")
    public void setVestingSchedule(VestingSchedule vestingSchedule) {
        this.vestingSchedule = vestingSchedule;
    }

    @JsonProperty(value="bonding_purse")
    public void setBondingPurse(URef bondingPurse) {
        this.bondingPurse = bondingPurse;
    }

    @JsonIgnore
    public void setStakedAmount(BigInteger stakedAmount) {
        this.stakedAmount = stakedAmount;
    }

    public Delegator(PublicKey validatorPublicKey, DelegatorKind delegatorKind, VestingSchedule vestingSchedule, URef bondingPurse, BigInteger stakedAmount) {
        this.validatorPublicKey = validatorPublicKey;
        this.delegatorKind = delegatorKind;
        this.vestingSchedule = vestingSchedule;
        this.bondingPurse = bondingPurse;
        this.stakedAmount = stakedAmount;
    }

    public Delegator() {
    }

    public static class DelegatorBuilder {
        private PublicKey validatorPublicKey;
        private DelegatorKind delegatorKind;
        private VestingSchedule vestingSchedule;
        private URef bondingPurse;
        private BigInteger stakedAmount;

        DelegatorBuilder() {
        }

        @JsonProperty(value="validator_public_key")
        public DelegatorBuilder validatorPublicKey(PublicKey validatorPublicKey) {
            this.validatorPublicKey = validatorPublicKey;
            return this;
        }

        @JsonProperty(value="delegator_kind")
        public DelegatorBuilder delegatorKind(DelegatorKind delegatorKind) {
            this.delegatorKind = delegatorKind;
            return this;
        }

        @JsonProperty(value="vesting_schedule")
        public DelegatorBuilder vestingSchedule(VestingSchedule vestingSchedule) {
            this.vestingSchedule = vestingSchedule;
            return this;
        }

        @JsonProperty(value="bonding_purse")
        public DelegatorBuilder bondingPurse(URef bondingPurse) {
            this.bondingPurse = bondingPurse;
            return this;
        }

        @JsonIgnore
        public DelegatorBuilder stakedAmount(BigInteger stakedAmount) {
            this.stakedAmount = stakedAmount;
            return this;
        }

        public Delegator build() {
            return new Delegator(this.validatorPublicKey, this.delegatorKind, this.vestingSchedule, this.bondingPurse, this.stakedAmount);
        }

        public String toString() {
            return "Delegator.DelegatorBuilder(validatorPublicKey=" + this.validatorPublicKey + ", delegatorKind=" + this.delegatorKind + ", vestingSchedule=" + this.vestingSchedule + ", bondingPurse=" + this.bondingPurse + ", stakedAmount=" + this.stakedAmount + ")";
        }
    }
}

