/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.bid;

import com.casper.sdk.annotation.ExcludeFromJacocoGeneratedReport;
import com.casper.sdk.model.bid.DelegatorEntry;
import com.casper.sdk.model.bid.VestingSchedule;
import com.casper.sdk.model.key.PublicKey;
import com.casper.sdk.model.uref.URef;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;
import java.util.List;

public class JsonBid {
    @JsonProperty(value="validator_public_key")
    private PublicKey validatorPublicKey;
    @JsonProperty(value="bonding_purse")
    private URef bondingPurse;
    @JsonProperty(value="delegation_rate")
    private int delegationRate;
    @JsonProperty(value="vesting_schedule")
    private VestingSchedule vestingSchedule;
    private List<DelegatorEntry> delegators;
    private boolean inactive;
    @JsonIgnore
    private BigInteger stakedAmount;

    @JsonProperty(value="staked_amount")
    @ExcludeFromJacocoGeneratedReport
    protected String getJsonStakedAmount() {
        return this.stakedAmount.toString(10);
    }

    @JsonProperty(value="staked_amount")
    @ExcludeFromJacocoGeneratedReport
    protected void setJsonStakedAmount(String value) {
        this.stakedAmount = new BigInteger(value, 10);
    }

    public static JsonBidBuilder builder() {
        return new JsonBidBuilder();
    }

    public PublicKey getValidatorPublicKey() {
        return this.validatorPublicKey;
    }

    public URef getBondingPurse() {
        return this.bondingPurse;
    }

    public int getDelegationRate() {
        return this.delegationRate;
    }

    public VestingSchedule getVestingSchedule() {
        return this.vestingSchedule;
    }

    public List<DelegatorEntry> getDelegators() {
        return this.delegators;
    }

    public boolean isInactive() {
        return this.inactive;
    }

    public BigInteger getStakedAmount() {
        return this.stakedAmount;
    }

    @JsonProperty(value="validator_public_key")
    public void setValidatorPublicKey(PublicKey validatorPublicKey) {
        this.validatorPublicKey = validatorPublicKey;
    }

    @JsonProperty(value="bonding_purse")
    public void setBondingPurse(URef bondingPurse) {
        this.bondingPurse = bondingPurse;
    }

    @JsonProperty(value="delegation_rate")
    public void setDelegationRate(int delegationRate) {
        this.delegationRate = delegationRate;
    }

    @JsonProperty(value="vesting_schedule")
    public void setVestingSchedule(VestingSchedule vestingSchedule) {
        this.vestingSchedule = vestingSchedule;
    }

    public void setDelegators(List<DelegatorEntry> delegators) {
        this.delegators = delegators;
    }

    public void setInactive(boolean inactive) {
        this.inactive = inactive;
    }

    @JsonIgnore
    public void setStakedAmount(BigInteger stakedAmount) {
        this.stakedAmount = stakedAmount;
    }

    public JsonBid(PublicKey validatorPublicKey, URef bondingPurse, int delegationRate, VestingSchedule vestingSchedule, List<DelegatorEntry> delegators, boolean inactive, BigInteger stakedAmount) {
        this.validatorPublicKey = validatorPublicKey;
        this.bondingPurse = bondingPurse;
        this.delegationRate = delegationRate;
        this.vestingSchedule = vestingSchedule;
        this.delegators = delegators;
        this.inactive = inactive;
        this.stakedAmount = stakedAmount;
    }

    public JsonBid() {
    }

    public static class JsonBidBuilder {
        private PublicKey validatorPublicKey;
        private URef bondingPurse;
        private int delegationRate;
        private VestingSchedule vestingSchedule;
        private List<DelegatorEntry> delegators;
        private boolean inactive;
        private BigInteger stakedAmount;

        JsonBidBuilder() {
        }

        @JsonProperty(value="validator_public_key")
        public JsonBidBuilder validatorPublicKey(PublicKey validatorPublicKey) {
            this.validatorPublicKey = validatorPublicKey;
            return this;
        }

        @JsonProperty(value="bonding_purse")
        public JsonBidBuilder bondingPurse(URef bondingPurse) {
            this.bondingPurse = bondingPurse;
            return this;
        }

        @JsonProperty(value="delegation_rate")
        public JsonBidBuilder delegationRate(int delegationRate) {
            this.delegationRate = delegationRate;
            return this;
        }

        @JsonProperty(value="vesting_schedule")
        public JsonBidBuilder vestingSchedule(VestingSchedule vestingSchedule) {
            this.vestingSchedule = vestingSchedule;
            return this;
        }

        public JsonBidBuilder delegators(List<DelegatorEntry> delegators) {
            this.delegators = delegators;
            return this;
        }

        public JsonBidBuilder inactive(boolean inactive) {
            this.inactive = inactive;
            return this;
        }

        @JsonIgnore
        public JsonBidBuilder stakedAmount(BigInteger stakedAmount) {
            this.stakedAmount = stakedAmount;
            return this;
        }

        public JsonBid build() {
            return new JsonBid(this.validatorPublicKey, this.bondingPurse, this.delegationRate, this.vestingSchedule, this.delegators, this.inactive, this.stakedAmount);
        }

        public String toString() {
            return "JsonBid.JsonBidBuilder(validatorPublicKey=" + this.validatorPublicKey + ", bondingPurse=" + this.bondingPurse + ", delegationRate=" + this.delegationRate + ", vestingSchedule=" + this.vestingSchedule + ", delegators=" + this.delegators + ", inactive=" + this.inactive + ", stakedAmount=" + this.stakedAmount + ")";
        }
    }
}

