/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.block;

import com.casper.sdk.model.block.Block;
import com.casper.sdk.model.block.BlockBodyV2;
import com.casper.sdk.model.block.BlockHeaderV2;
import com.fasterxml.jackson.annotation.JsonProperty;

public class BlockV2
extends Block<BlockHeaderV2, BlockBodyV2> {
    @JsonProperty(value="header")
    private BlockHeaderV2 header;
    @JsonProperty(value="body")
    private BlockBodyV2 body;

    public static BlockV2Builder builder() {
        return new BlockV2Builder();
    }

    @Override
    public BlockHeaderV2 getHeader() {
        return this.header;
    }

    @Override
    public BlockBodyV2 getBody() {
        return this.body;
    }

    @JsonProperty(value="header")
    public void setHeader(BlockHeaderV2 header) {
        this.header = header;
    }

    @JsonProperty(value="body")
    public void setBody(BlockBodyV2 body) {
        this.body = body;
    }

    public BlockV2(BlockHeaderV2 header, BlockBodyV2 body) {
        this.header = header;
        this.body = body;
    }

    public BlockV2() {
    }

    public static class BlockV2Builder {
        private BlockHeaderV2 header;
        private BlockBodyV2 body;

        BlockV2Builder() {
        }

        @JsonProperty(value="header")
        public BlockV2Builder header(BlockHeaderV2 header) {
            this.header = header;
            return this;
        }

        @JsonProperty(value="body")
        public BlockV2Builder body(BlockBodyV2 body) {
            this.body = body;
            return this;
        }

        public BlockV2 build() {
            return new BlockV2(this.header, this.body);
        }

        public String toString() {
            return "BlockV2.BlockV2Builder(header=" + this.header + ", body=" + this.body + ")";
        }
    }
}

