/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.contract.entrypoint;

import com.casper.sdk.annotation.ExcludeFromJacocoGeneratedReport;
import com.casper.sdk.model.clvalue.cltype.AbstractCLType;
import com.casper.sdk.model.clvalue.cltype.AbstractCLTypeBasic;
import com.casper.sdk.model.contract.Parameter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.ArrayList;
import java.util.List;

public class EntryPoint {
    @JsonIgnore
    private EntryPointAccess access;
    private List<Parameter> args;
    @JsonProperty(value="entry_point_type")
    private EntryPointType type;
    @JsonProperty(value="entry_point_payment")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private EntryPointPayment payment;
    private String name;
    @JsonIgnore
    private AbstractCLType ret;

    @JsonGetter(value="access")
    private Object getJsonAccess() {
        return this.access.getValue();
    }

    @JsonSetter(value="access")
    private void setJsonAccess(Object access) {
        if (access instanceof String) {
            this.access = EntryPointAccessEnum.PUBLIC;
        } else if (access instanceof List) {
            this.access = new EntryPointAccessList((ArrayList)access);
        }
    }

    @JsonSetter(value="ret")
    @ExcludeFromJacocoGeneratedReport
    protected void setJsonRet(AbstractCLType clType) {
        this.ret = clType;
    }

    @JsonGetter(value="ret")
    @ExcludeFromJacocoGeneratedReport
    protected Object getJsonRet() {
        if (this.ret instanceof AbstractCLTypeBasic) {
            return this.ret.getTypeName();
        }
        return this.ret;
    }

    public static EntryPointBuilder builder() {
        return new EntryPointBuilder();
    }

    public EntryPointAccess getAccess() {
        return this.access;
    }

    public List<Parameter> getArgs() {
        return this.args;
    }

    public EntryPointType getType() {
        return this.type;
    }

    public EntryPointPayment getPayment() {
        return this.payment;
    }

    public String getName() {
        return this.name;
    }

    public AbstractCLType getRet() {
        return this.ret;
    }

    @JsonIgnore
    public void setAccess(EntryPointAccess access) {
        this.access = access;
    }

    public void setArgs(List<Parameter> args) {
        this.args = args;
    }

    @JsonProperty(value="entry_point_type")
    public void setType(EntryPointType type) {
        this.type = type;
    }

    @JsonProperty(value="entry_point_payment")
    public void setPayment(EntryPointPayment payment) {
        this.payment = payment;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public void setRet(AbstractCLType ret) {
        this.ret = ret;
    }

    public EntryPoint(EntryPointAccess access, List<Parameter> args, EntryPointType type, EntryPointPayment payment, String name, AbstractCLType ret) {
        this.access = access;
        this.args = args;
        this.type = type;
        this.payment = payment;
        this.name = name;
        this.ret = ret;
    }

    public EntryPoint() {
    }

    public static class EntryPointBuilder {
        private EntryPointAccess access;
        private List<Parameter> args;
        private EntryPointType type;
        private EntryPointPayment payment;
        private String name;
        private AbstractCLType ret;

        EntryPointBuilder() {
        }

        @JsonIgnore
        public EntryPointBuilder access(EntryPointAccess access) {
            this.access = access;
            return this;
        }

        public EntryPointBuilder args(List<Parameter> args) {
            this.args = args;
            return this;
        }

        @JsonProperty(value="entry_point_type")
        public EntryPointBuilder type(EntryPointType type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="entry_point_payment")
        public EntryPointBuilder payment(EntryPointPayment payment) {
            this.payment = payment;
            return this;
        }

        public EntryPointBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonIgnore
        public EntryPointBuilder ret(AbstractCLType ret) {
            this.ret = ret;
            return this;
        }

        public EntryPoint build() {
            return new EntryPoint(this.access, this.args, this.type, this.payment, this.name, this.ret);
        }

        public String toString() {
            return "EntryPoint.EntryPointBuilder(access=" + this.access + ", args=" + this.args + ", type=" + (Object)((Object)this.type) + ", payment=" + (Object)((Object)this.payment) + ", name=" + this.name + ", ret=" + this.ret + ")";
        }
    }

    public static enum EntryPointPayment {
        SELF_ONLY,
        CALLER,
        SELF_ONWARD;

    }

    public static enum EntryPointType {
        SESSION,
        CONTRACT,
        CALLED,
        CALLER,
        FACTORY;

    }

    public static class EntryPointAccessList
    implements EntryPointAccess {
        private List<String> groups;

        @Override
        public List<String> getValue() {
            return this.groups;
        }

        public EntryPointAccessList(List<String> groups) {
            this.groups = groups;
        }

        public List<String> getGroups() {
            return this.groups;
        }
    }

    public static enum EntryPointAccessEnum implements EntryPointAccess
    {
        PUBLIC;


        @Override
        public EntryPointAccessEnum getValue() {
            return this;
        }
    }

    public static interface EntryPointAccess {
        public Object getValue();
    }
}

