/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.deploy;

import com.casper.sdk.exception.CasperClientException;
import com.casper.sdk.model.deploy.DelegatorKind;
import com.casper.sdk.model.key.PublicKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.security.NoSuchAlgorithmException;

@JsonTypeName(value="PublicKey")
public class DelegatorKindPublicKey
implements DelegatorKind {
    @JsonValue
    private PublicKey publicKey;

    @JsonCreator
    public DelegatorKindPublicKey(String publicKey) {
        try {
            this.publicKey = PublicKey.fromTaggedHexString(publicKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CasperClientException("Invalid public key bytes", e);
        }
    }

    public static DelegatorKindPublicKeyBuilder builder() {
        return new DelegatorKindPublicKeyBuilder();
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public DelegatorKindPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public static class DelegatorKindPublicKeyBuilder {
        private PublicKey publicKey;

        DelegatorKindPublicKeyBuilder() {
        }

        public DelegatorKindPublicKeyBuilder publicKey(PublicKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public DelegatorKindPublicKey build() {
            return new DelegatorKindPublicKey(this.publicKey);
        }

        public String toString() {
            return "DelegatorKindPublicKey.DelegatorKindPublicKeyBuilder(publicKey=" + this.publicKey + ")";
        }
    }
}

