/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.deploy;

import com.casper.sdk.exception.CasperClientException;
import com.casper.sdk.exception.DynamicInstanceException;
import com.casper.sdk.model.deploy.DelegatorKind;
import com.casper.sdk.model.uref.URef;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;

@JsonTypeName(value="Purse")
public class DelegatorKindPurse
implements DelegatorKind {
    @JsonValue
    private String purseStr;
    @JsonIgnore
    private URef purse;

    @JsonCreator
    public DelegatorKindPurse(String purse) {
        try {
            this.purseStr = purse;
            this.purse = URef.fromString(purse.startsWith("uref-") ? purse : "uref-" + purse + "-000");
        }
        catch (DynamicInstanceException | IOException e) {
            throw new CasperClientException("Invalid purse bytes", e);
        }
    }

    public static DelegatorKindPurseBuilder builder() {
        return new DelegatorKindPurseBuilder();
    }

    public URef getPurse() {
        return this.purse;
    }

    public void setPurseStr(String purseStr) {
        this.purseStr = purseStr;
    }

    @JsonIgnore
    public void setPurse(URef purse) {
        this.purse = purse;
    }

    public DelegatorKindPurse(String purseStr, URef purse) {
        this.purseStr = purseStr;
        this.purse = purse;
    }

    public static class DelegatorKindPurseBuilder {
        private String purseStr;
        private URef purse;

        DelegatorKindPurseBuilder() {
        }

        public DelegatorKindPurseBuilder purseStr(String purseStr) {
            this.purseStr = purseStr;
            return this;
        }

        @JsonIgnore
        public DelegatorKindPurseBuilder purse(URef purse) {
            this.purse = purse;
            return this;
        }

        public DelegatorKindPurse build() {
            return new DelegatorKindPurse(this.purseStr, this.purse);
        }

        public String toString() {
            return "DelegatorKindPurse.DelegatorKindPurseBuilder(purseStr=" + this.purseStr + ", purse=" + this.purse + ")";
        }
    }
}

