/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.deploy;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.serde.CasperSerializableObject;
import com.casper.sdk.model.clvalue.serde.Target;
import com.casper.sdk.model.common.Digest;
import com.casper.sdk.model.common.Ttl;
import com.casper.sdk.model.key.PublicKey;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import java.util.Date;
import java.util.List;

public class DeployHeader
implements CasperSerializableObject {
    private PublicKey account;
    @JsonProperty(value="body_hash")
    private Digest bodyHash;
    @JsonProperty(value="chain_name")
    private String chainName;
    private List<Digest> dependencies;
    @JsonProperty(value="gas_price")
    private Long gasPrice;
    @JsonProperty(value="timestamp")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date timeStamp;
    private Ttl ttl;

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws NoSuchTypeException, ValueSerializationException {
        this.account.serialize(ser, target);
        ser.writeI64(this.timeStamp.getTime());
        this.ttl.serialize(ser, target);
        ser.writeI64(this.gasPrice);
        this.bodyHash.serialize(ser, target);
        if (this.dependencies != null) {
            ser.writeI32(this.dependencies.size());
            for (Digest dependency : this.dependencies) {
                ser.writeByteArray(dependency.getDigest());
            }
        }
        ser.writeString(this.chainName);
    }

    public Digest buildHash() throws NoSuchTypeException, ValueSerializationException {
        SerializerBuffer serializerBuffer = new SerializerBuffer();
        this.serialize(serializerBuffer, Target.BYTE);
        return Digest.blake2bDigestFromBytes(serializerBuffer.toByteArray());
    }

    public static DeployHeaderBuilder builder() {
        return new DeployHeaderBuilder();
    }

    public PublicKey getAccount() {
        return this.account;
    }

    public Digest getBodyHash() {
        return this.bodyHash;
    }

    public String getChainName() {
        return this.chainName;
    }

    public List<Digest> getDependencies() {
        return this.dependencies;
    }

    public Long getGasPrice() {
        return this.gasPrice;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public Ttl getTtl() {
        return this.ttl;
    }

    public void setAccount(PublicKey account) {
        this.account = account;
    }

    @JsonProperty(value="body_hash")
    public void setBodyHash(Digest bodyHash) {
        this.bodyHash = bodyHash;
    }

    @JsonProperty(value="chain_name")
    public void setChainName(String chainName) {
        this.chainName = chainName;
    }

    public void setDependencies(List<Digest> dependencies) {
        this.dependencies = dependencies;
    }

    @JsonProperty(value="gas_price")
    public void setGasPrice(Long gasPrice) {
        this.gasPrice = gasPrice;
    }

    @JsonProperty(value="timestamp")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setTtl(Ttl ttl) {
        this.ttl = ttl;
    }

    public DeployHeader(PublicKey account, Digest bodyHash, String chainName, List<Digest> dependencies, Long gasPrice, Date timeStamp, Ttl ttl) {
        this.account = account;
        this.bodyHash = bodyHash;
        this.chainName = chainName;
        this.dependencies = dependencies;
        this.gasPrice = gasPrice;
        this.timeStamp = timeStamp;
        this.ttl = ttl;
    }

    public DeployHeader() {
    }

    public static class DeployHeaderBuilder {
        private PublicKey account;
        private Digest bodyHash;
        private String chainName;
        private List<Digest> dependencies;
        private Long gasPrice;
        private Date timeStamp;
        private Ttl ttl;

        DeployHeaderBuilder() {
        }

        public DeployHeaderBuilder account(PublicKey account) {
            this.account = account;
            return this;
        }

        @JsonProperty(value="body_hash")
        public DeployHeaderBuilder bodyHash(Digest bodyHash) {
            this.bodyHash = bodyHash;
            return this;
        }

        @JsonProperty(value="chain_name")
        public DeployHeaderBuilder chainName(String chainName) {
            this.chainName = chainName;
            return this;
        }

        public DeployHeaderBuilder dependencies(List<Digest> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        @JsonProperty(value="gas_price")
        public DeployHeaderBuilder gasPrice(Long gasPrice) {
            this.gasPrice = gasPrice;
            return this;
        }

        @JsonProperty(value="timestamp")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
        public DeployHeaderBuilder timeStamp(Date timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        public DeployHeaderBuilder ttl(Ttl ttl) {
            this.ttl = ttl;
            return this;
        }

        public DeployHeader build() {
            return new DeployHeader(this.account, this.bodyHash, this.chainName, this.dependencies, this.gasPrice, this.timeStamp, this.ttl);
        }

        public String toString() {
            return "DeployHeader.DeployHeaderBuilder(account=" + this.account + ", bodyHash=" + this.bodyHash + ", chainName=" + this.chainName + ", dependencies=" + this.dependencies + ", gasPrice=" + this.gasPrice + ", timeStamp=" + this.timeStamp + ", ttl=" + this.ttl + ")";
        }
    }
}

