/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.entity;

import com.casper.sdk.exception.NoSuchKeyTagException;
import com.casper.sdk.model.key.Tag;

public enum EntityAddr implements Tag
{
    SYSTEM(0, "system"),
    ACCOUNT(1, "account"),
    SMART_CONTRACT(2, "contract");

    private final byte byteTag;
    private final String keyName;

    public static EntityAddr getByTag(byte tag) throws NoSuchKeyTagException {
        for (EntityAddr a : EntityAddr.values()) {
            if (a.byteTag != tag) continue;
            return a;
        }
        throw new NoSuchKeyTagException();
    }

    public static EntityAddr getByKeyName(String keyName) throws NoSuchKeyTagException {
        for (EntityAddr entityAddr : EntityAddr.values()) {
            if (!entityAddr.getKeyName().equals(keyName)) continue;
            return entityAddr;
        }
        throw new NoSuchKeyTagException("No such key name: " + keyName);
    }

    private EntityAddr(byte byteTag, String keyName) {
        this.byteTag = byteTag;
        this.keyName = keyName;
    }

    @Override
    public byte getByteTag() {
        return this.byteTag;
    }

    public String getKeyName() {
        return this.keyName;
    }
}

