/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.era;

import com.casper.sdk.exception.InvalidKeyBytesException;
import com.casper.sdk.model.era.ValidatorWeight;
import com.casper.sdk.model.key.PublicKey;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EraEndV2 {
    @JsonProperty(value="equivocators")
    private List<PublicKey> equivocators;
    @JsonProperty(value="inactive_validators")
    private List<PublicKey> inactiveValidators;
    @JsonProperty(value="next_era_validator_weights")
    private List<ValidatorWeight> nextEraValidatorWeights;
    @JsonProperty(value="rewards")
    private Map<PublicKey, List<BigInteger>> rewards;
    @JsonProperty(value="next_era_gas_price")
    private int nextEraGasPrice;

    @JsonSetter(value="rewards")
    public void setRewards(Map<String, List<BigInteger>> rewards) {
        this.rewards = new LinkedHashMap<PublicKey, List<BigInteger>>();
        if (rewards != null) {
            rewards.forEach((key, value) -> {
                try {
                    this.rewards.put(PublicKey.fromTaggedHexString(key), (List<BigInteger>)value);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new InvalidKeyBytesException(e);
                }
            });
        }
    }

    public EraEndV2(List<PublicKey> equivocators, List<PublicKey> inactiveValidators, List<ValidatorWeight> nextEraValidatorWeights, Map<PublicKey, List<BigInteger>> rewards, int nextEraGasPrice) {
        this.equivocators = equivocators;
        this.inactiveValidators = inactiveValidators;
        this.nextEraValidatorWeights = nextEraValidatorWeights;
        this.rewards = rewards;
        this.nextEraGasPrice = nextEraGasPrice;
    }

    public EraEndV2() {
    }

    public List<PublicKey> getEquivocators() {
        return this.equivocators;
    }

    public List<PublicKey> getInactiveValidators() {
        return this.inactiveValidators;
    }

    public List<ValidatorWeight> getNextEraValidatorWeights() {
        return this.nextEraValidatorWeights;
    }

    public Map<PublicKey, List<BigInteger>> getRewards() {
        return this.rewards;
    }

    public int getNextEraGasPrice() {
        return this.nextEraGasPrice;
    }

    @JsonProperty(value="equivocators")
    public void setEquivocators(List<PublicKey> equivocators) {
        this.equivocators = equivocators;
    }

    @JsonProperty(value="inactive_validators")
    public void setInactiveValidators(List<PublicKey> inactiveValidators) {
        this.inactiveValidators = inactiveValidators;
    }

    @JsonProperty(value="next_era_validator_weights")
    public void setNextEraValidatorWeights(List<ValidatorWeight> nextEraValidatorWeights) {
        this.nextEraValidatorWeights = nextEraValidatorWeights;
    }

    @JsonProperty(value="next_era_gas_price")
    public void setNextEraGasPrice(int nextEraGasPrice) {
        this.nextEraGasPrice = nextEraGasPrice;
    }
}

