/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.event;

import com.casper.sdk.model.event.EventData;
import com.casper.sdk.model.event.blockadded.BlockAdded;
import com.casper.sdk.model.event.deployaccepted.DeployAccepted;
import com.casper.sdk.model.event.deployexpired.DeployExpired;
import com.casper.sdk.model.event.deployprocessed.DeployProcessed;
import com.casper.sdk.model.event.fault.Fault;
import com.casper.sdk.model.event.finalitysignature.FinalitySignature;
import com.casper.sdk.model.event.shutdown.Shutdown;
import com.casper.sdk.model.event.step.Step;
import com.casper.sdk.model.event.transaction.TransactionAccepted;
import com.casper.sdk.model.event.transaction.TransactionExpired;
import com.casper.sdk.model.event.transaction.TransactionProcessed;
import com.casper.sdk.model.event.version.ApiVersion;

public enum DataType {
    API_VERSION(ApiVersion.class),
    BLOCK_ADDED(BlockAdded.class),
    DEPLOY_ACCEPTED(DeployAccepted.class),
    DEPLOY_EXPIRED(DeployExpired.class),
    DEPLOY_PROCESSED(DeployProcessed.class),
    FAULT(Fault.class),
    FINALITY_SIGNATURE(FinalitySignature.class),
    SHUTDOWN(Shutdown.class),
    STEP(Step.class),
    TRANSACTION_ACCEPTED(TransactionAccepted.class),
    TRANSACTION_EXPIRED(TransactionExpired.class),
    TRANSACTION_PROCESSED(TransactionProcessed.class);

    private final Class<? extends EventData> dataType;

    private DataType(Class<? extends EventData> dataType) {
        this.dataType = dataType;
    }

    public static DataType of(Class<?> dataTypeClass) {
        for (DataType dataType : DataType.values()) {
            if (!dataType.dataType.equals(dataTypeClass)) continue;
            return dataType;
        }
        return null;
    }

    public static DataType of(String dataTypeSimpleClassName) {
        for (DataType dataType : DataType.values()) {
            if (!dataType.dataType.getSimpleName().equals(dataTypeSimpleClassName)) continue;
            return dataType;
        }
        return null;
    }

    public String getDataTypeName() {
        return this.dataType.getSimpleName();
    }
}

