/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.key;

import com.casper.sdk.model.key.BalanceHoldAddr;
import com.casper.sdk.model.key.Key;
import com.casper.sdk.model.key.KeyTag;
import com.syntifi.crypto.key.encdec.Hex;
import dev.oak3.sbs4j.DeserializerBuffer;
import dev.oak3.sbs4j.SerializerBuffer;
import java.math.BigInteger;

public class BalanceHoldKey
extends Key {
    private BalanceHoldAddr balanceHoldAddr;
    private byte[] urefAddr;
    private BigInteger blockTime;

    @Override
    protected void fromStringCustom(String strKey) {
        String[] split = strKey.split("-");
        try {
            this.deserializeCustom(new DeserializerBuffer(Hex.decode(split[split.length - 1])));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid key: " + strKey, e);
        }
    }

    @Override
    protected void deserializeCustom(DeserializerBuffer deser) throws Exception {
        this.setTag(KeyTag.BALANCE_HOLD);
        SerializerBuffer ser = new SerializerBuffer();
        this.balanceHoldAddr = BalanceHoldAddr.getByTag(deser.readU8());
        ser.writeU8(this.balanceHoldAddr.getByteTag());
        this.urefAddr = deser.readByteArray(32);
        ser.writeByteArray(this.urefAddr);
        this.blockTime = deser.readU64();
        ser.writeU64(this.blockTime);
        this.setKey(ser.toByteArray());
    }

    public BalanceHoldKey(BalanceHoldAddr balanceHoldAddr, byte[] urefAddr, BigInteger blockTime) {
        this.balanceHoldAddr = balanceHoldAddr;
        this.urefAddr = urefAddr;
        this.blockTime = blockTime;
    }

    public BalanceHoldKey() {
    }

    public BalanceHoldAddr getBalanceHoldAddr() {
        return this.balanceHoldAddr;
    }

    public byte[] getUrefAddr() {
        return this.urefAddr;
    }

    public BigInteger getBlockTime() {
        return this.blockTime;
    }

    public void setBalanceHoldAddr(BalanceHoldAddr balanceHoldAddr) {
        this.balanceHoldAddr = balanceHoldAddr;
    }

    public void setUrefAddr(byte[] urefAddr) {
        this.urefAddr = urefAddr;
    }

    public void setBlockTime(BigInteger blockTime) {
        this.blockTime = blockTime;
    }
}

