/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.key;

import com.casper.sdk.exception.NoSuchKeyTagException;
import com.casper.sdk.model.key.BidAddr;
import com.casper.sdk.model.key.Key;
import com.syntifi.crypto.key.encdec.Hex;
import dev.oak3.sbs4j.DeserializerBuffer;

public class BidAddrKey
extends Key {
    private BidAddr bidAddr;

    @Override
    protected void fromStringCustom(String strKey) {
        String[] parts = strKey.split("-");
        try {
            this.bidAddr = BidAddr.getByTag(Hex.decode(parts[parts.length - 1].substring(0, 2))[0]);
            this.setKey(Hex.decode(parts[parts.length - 1]));
        }
        catch (NoSuchKeyTagException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    protected void deserializeCustom(DeserializerBuffer deser) throws Exception {
        this.bidAddr = BidAddr.getByTag(deser.readU8());
        int len = BidAddr.DELEGATOR_ACCOUNT == this.bidAddr ? 65 : (BidAddr.CREDIT == this.bidAddr ? 41 : 32);
        byte[] key = new byte[len + 1];
        key[0] = this.bidAddr.getByteTag();
        System.arraycopy(deser.readByteArray(len), 0, key, 1, len);
        this.setKey(key);
    }

    public BidAddrKey(BidAddr bidAddr) {
        this.bidAddr = bidAddr;
    }

    public BidAddrKey() {
    }

    public BidAddr getBidAddr() {
        return this.bidAddr;
    }
}

