/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.key;

import com.casper.sdk.model.key.BlockGlobalAddr;
import com.casper.sdk.model.key.Key;
import com.casper.sdk.model.key.KeyTag;
import com.syntifi.crypto.key.encdec.Hex;
import dev.oak3.sbs4j.DeserializerBuffer;
import dev.oak3.sbs4j.SerializerBuffer;

public class BlockGlobalKey
extends Key {
    private BlockGlobalAddr blockGlobalAddr;

    @Override
    public String toString() {
        return ((KeyTag)this.getTag()).getKeyName() + this.blockGlobalAddr.getKeyName() + "-" + Hex.encode(this.getKey()).substring(2);
    }

    @Override
    protected void fromStringCustom(String strKey) {
        this.blockGlobalAddr = BlockGlobalAddr.getByKeyName(strKey);
        super.fromStringCustom(strKey);
        SerializerBuffer ser = new SerializerBuffer();
        ser.writeU8(this.blockGlobalAddr.getByteTag());
        String[] split = strKey.split("-");
        ser.writeByteArray(Hex.decode(split[split.length - 1]));
        this.setKey(ser.toByteArray());
    }

    @Override
    protected void deserializeCustom(DeserializerBuffer deser) throws Exception {
        this.setTag(KeyTag.BLOCK_GLOBAL);
        this.setKey(deser.readByteArray(33));
        this.blockGlobalAddr = BlockGlobalAddr.getByTag(this.getKey()[0]);
    }

    public BlockGlobalKey(BlockGlobalAddr blockGlobalAddr) {
        this.blockGlobalAddr = blockGlobalAddr;
    }

    public BlockGlobalKey() {
    }

    public BlockGlobalAddr getBlockGlobalAddr() {
        return this.blockGlobalAddr;
    }

    public void setBlockGlobalAddr(BlockGlobalAddr blockGlobalAddr) {
        this.blockGlobalAddr = blockGlobalAddr;
    }
}

