/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.key;

import com.casper.sdk.exception.NoSuchKeyTagException;
import com.casper.sdk.model.key.Tag;

public enum EntryPointAddr implements Tag
{
    VM_CASPER_V1(0),
    VM_CASPER_V2(1);

    private final byte byteTag;

    public static EntryPointAddr getByKeyName(String keyName) throws NoSuchKeyTagException {
        String lowerCaseKeyName = keyName.toLowerCase();
        if (lowerCaseKeyName.contains("v2")) {
            return VM_CASPER_V2;
        }
        if (lowerCaseKeyName.contains("v1")) {
            return VM_CASPER_V1;
        }
        throw new NoSuchKeyTagException("No such key name: " + keyName);
    }

    public static EntryPointAddr getByTag(byte byteTag) {
        for (EntryPointAddr addr : EntryPointAddr.values()) {
            if (addr.byteTag != byteTag) continue;
            return addr;
        }
        throw new IllegalArgumentException("No such EntryPointAddr: " + byteTag);
    }

    private EntryPointAddr(byte byteTag) {
        this.byteTag = byteTag;
    }

    @Override
    public byte getByteTag() {
        return this.byteTag;
    }
}

