/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.key;

import com.casper.sdk.exception.NoSuchKeyTagException;
import com.casper.sdk.jackson.deserializer.KeyDeserializer;
import com.casper.sdk.jackson.serializer.KeySerializer;
import com.casper.sdk.model.key.AbstractSerializedKeyTaggedHex;
import com.casper.sdk.model.key.KeyTag;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.syntifi.crypto.key.hash.Blake2b;
import dev.oak3.sbs4j.DeserializerBuffer;
import dev.oak3.sbs4j.util.ByteUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

@JsonDeserialize(using=KeyDeserializer.class)
@JsonSerialize(using=KeySerializer.class)
public class Key
extends AbstractSerializedKeyTaggedHex<KeyTag> {
    public static Key deserialize(DeserializerBuffer deser) throws NoSuchKeyTagException {
        try {
            KeyTag keyTag = KeyTag.getByTag(deser.readU8());
            Key key = keyTag.getKeyClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            key.setTag(keyTag);
            key.deserializeCustom(deser);
            return key;
        }
        catch (NoSuchKeyTagException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NoSuchKeyTagException("Error deserializing key", e);
        }
    }

    @JsonCreator
    public static Key create(String strKey) throws NoSuchKeyTagException {
        KeyTag keyTag = KeyTag.getByKeyName(strKey);
        try {
            Key key = keyTag.getKeyClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            key.setTag(keyTag);
            key.fromStringCustom(strKey);
            return key;
        }
        catch (Exception e) {
            throw new NoSuchKeyTagException("Error deserializing key: " + strKey, e);
        }
    }

    public static Key fromTaggedHexString(String hex) throws NoSuchKeyTagException {
        byte[] bytes = ByteUtils.parseHexString(hex);
        return Key.deserialize(new DeserializerBuffer(bytes));
    }

    public String generateAccountHash(boolean includePrefix) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(((KeyTag)this.getTag()).toString().toLowerCase().getBytes(StandardCharsets.UTF_8));
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(this.getKey());
        return (includePrefix ? "account-hash-" : "") + ByteUtils.encodeHexString(Blake2b.digest(byteArrayOutputStream.toByteArray(), 32));
    }

    @Override
    @JsonDeserialize
    public String toString() {
        return ((KeyTag)this.getTag()).getKeyName() + ByteUtils.encodeHexString(this.getKey());
    }

    protected void deserializeCustom(DeserializerBuffer deser) throws Exception {
        this.setKey(deser.readByteArray(32));
    }

    protected void fromStringCustom(String strKey) {
        String[] split = strKey.split("-");
        this.setKey(ByteUtils.parseHexString(split[split.length - 1]));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Key)) {
            return false;
        }
        Key other = (Key)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Key;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

