/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.key;

import com.casper.sdk.exception.NoSuchKeyTagException;
import com.casper.sdk.model.common.Digest;
import com.casper.sdk.model.entity.EntityAddr;
import com.casper.sdk.model.key.Key;
import com.casper.sdk.model.key.KeyTag;
import dev.oak3.sbs4j.DeserializerBuffer;
import dev.oak3.sbs4j.SerializerBuffer;
import java.util.Optional;

public class MessageKey
extends Key {
    public static final String TOPIC = "topic";
    private EntityAddr entityAddr;
    private Digest entityAddrHash;
    private Long messageIndex;
    private Digest topicHash;

    @Override
    protected void deserializeCustom(DeserializerBuffer deser) throws Exception {
        this.entityAddr = EntityAddr.getByTag(deser.readU8());
        byte[] entityAddrHash = deser.readByteArray(32);
        this.entityAddrHash = new Digest();
        this.entityAddrHash.setDigest(entityAddrHash);
        byte[] topicNameHash = deser.readByteArray(32);
        this.topicHash = new Digest();
        this.topicHash.setDigest(topicNameHash);
        Boolean isMessageIndexPresent = deser.readBool();
        if (isMessageIndexPresent.booleanValue()) {
            this.messageIndex = deser.readU32();
        }
        this.refreshKey();
    }

    public Optional<Long> getMessageIndex() {
        return Optional.ofNullable(this.messageIndex);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(((KeyTag)this.getTag()).getKeyName());
        if (this.messageIndex == null) {
            builder.append(TOPIC).append('-');
        }
        if (this.entityAddr != null) {
            builder.append("entity").append('-').append(this.entityAddr.getKeyName()).append('-');
        }
        builder.append(this.entityAddrHash).append('-').append(this.topicHash);
        if (this.messageIndex != null) {
            builder.append('-').append(String.format("%x", this.messageIndex));
        }
        return builder.toString();
    }

    @Override
    protected void fromStringCustom(String strKey) {
        String[] split = strKey.split("-");
        if (TOPIC.equals(split[1])) {
            if (split.length > 4) {
                try {
                    this.entityAddr = EntityAddr.getByKeyName(split[3]);
                }
                catch (NoSuchKeyTagException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            this.entityAddrHash = new Digest(split[split.length - 2]);
            this.topicHash = new Digest(split[split.length - 1]);
        } else {
            try {
                this.entityAddr = EntityAddr.getByKeyName(split[2]);
            }
            catch (NoSuchKeyTagException e) {
                throw new IllegalArgumentException(e);
            }
            this.entityAddrHash = new Digest(split[3]);
            this.topicHash = new Digest(split[4]);
            if (split.length > 5) {
                this.messageIndex = Long.parseLong(split[5], 16);
            }
        }
        this.refreshKey();
    }

    private void refreshKey() {
        SerializerBuffer serializerBuffer = new SerializerBuffer();
        if (this.entityAddr != null) {
            serializerBuffer.writeU8(this.entityAddr.getByteTag());
        } else {
            serializerBuffer.writeU8((byte)0);
        }
        serializerBuffer.writeByteArray(this.entityAddrHash.getDigest());
        serializerBuffer.writeByteArray(this.topicHash.getDigest());
        if (this.messageIndex != null) {
            serializerBuffer.writeBool(true);
            serializerBuffer.writeU32(this.messageIndex);
        } else {
            serializerBuffer.writeBool(false);
        }
        this.setKey(serializerBuffer.toByteArray());
    }

    public MessageKey(EntityAddr entityAddr, Digest entityAddrHash, Long messageIndex, Digest topicHash) {
        this.entityAddr = entityAddr;
        this.entityAddrHash = entityAddrHash;
        this.messageIndex = messageIndex;
        this.topicHash = topicHash;
    }

    public MessageKey() {
    }

    public EntityAddr getEntityAddr() {
        return this.entityAddr;
    }

    public Digest getEntityAddrHash() {
        return this.entityAddrHash;
    }

    public Digest getTopicHash() {
        return this.topicHash;
    }

    public void setEntityAddr(EntityAddr entityAddr) {
        this.entityAddr = entityAddr;
    }

    public void setEntityAddrHash(Digest entityAddrHash) {
        this.entityAddrHash = entityAddrHash;
    }

    public void setMessageIndex(Long messageIndex) {
        this.messageIndex = messageIndex;
    }

    public void setTopicHash(Digest topicHash) {
        this.topicHash = topicHash;
    }
}

