/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.key;

import com.casper.sdk.exception.NoSuchKeyTagException;
import com.casper.sdk.model.key.AddressableEntityKey;
import com.casper.sdk.model.key.Key;
import com.casper.sdk.model.key.KeyTag;
import com.syntifi.crypto.key.encdec.Hex;
import dev.oak3.sbs4j.DeserializerBuffer;
import dev.oak3.sbs4j.SerializerBuffer;
import java.util.Arrays;

public class NamedKeyKey
extends Key {
    private AddressableEntityKey baseAddr;
    private byte[] stringBytes;

    @Override
    protected void fromStringCustom(String strKey) {
        String[] split = strKey.split("-");
        try {
            String baseAddrStr = split[2] + "-" + split[3] + "-" + split[4];
            this.baseAddr = (AddressableEntityKey)Key.create(baseAddrStr);
            this.stringBytes = Hex.decode(split[5]);
            this.refreshKey();
        }
        catch (NoSuchKeyTagException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String toString() {
        return ((KeyTag)this.getTag()).getKeyName() + this.baseAddr + "-" + Hex.encode(this.stringBytes);
    }

    @Override
    protected void deserializeCustom(DeserializerBuffer deser) throws Exception {
        this.setKey(deser.readByteArray(65));
        this.baseAddr = new AddressableEntityKey();
        this.baseAddr.deserializeCustom(new DeserializerBuffer(Arrays.copyOfRange(this.getKey(), 0, 33)));
        this.stringBytes = Arrays.copyOfRange(this.getKey(), 33, 65);
    }

    private void refreshKey() {
        SerializerBuffer ser = new SerializerBuffer();
        ser.writeU8(this.baseAddr.getEntityAddressTag().getByteTag());
        ser.writeByteArray(this.baseAddr.getKey());
        ser.writeByteArray(this.stringBytes);
        this.setKey(ser.toByteArray());
    }

    public NamedKeyKey(AddressableEntityKey baseAddr, byte[] stringBytes) {
        this.baseAddr = baseAddr;
        this.stringBytes = stringBytes;
    }

    public NamedKeyKey() {
    }

    public AddressableEntityKey getBaseAddr() {
        return this.baseAddr;
    }

    public byte[] getStringBytes() {
        return this.stringBytes;
    }

    public void setBaseAddr(AddressableEntityKey baseAddr) {
        this.baseAddr = baseAddr;
    }

    public void setStringBytes(byte[] stringBytes) {
        this.stringBytes = stringBytes;
    }
}

