/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.transaction;

import com.casper.sdk.exception.CasperClientException;
import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.serde.Target;
import com.casper.sdk.model.common.Digest;
import com.casper.sdk.model.deploy.Approval;
import com.casper.sdk.model.key.PublicKey;
import com.casper.sdk.model.key.Signature;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.syntifi.crypto.key.AbstractPrivateKey;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTransaction {
    @JsonProperty(value="hash")
    private Digest hash;
    @JsonProperty(value="approvals")
    private List<Approval> approvals = new ArrayList<Approval>();

    protected void serializeApprovals(SerializerBuffer ser, Target target) throws ValueSerializationException, NoSuchTypeException {
        ser.writeI32(this.approvals.size());
        for (Approval approval : this.approvals) {
            approval.serialize(ser, target);
        }
    }

    protected abstract void calculateHash();

    public <T extends AbstractTransaction> T sign(AbstractPrivateKey signer) {
        try {
            if (this.hash == null) {
                this.calculateHash();
            }
            Signature signature = Signature.sign(signer, this.hash.getDigest());
            this.getApprovals().add(Approval.builder().signer(PublicKey.fromAbstractPublicKey(signer.derivePublicKey())).signature(signature).build());
            return (T)this;
        }
        catch (GeneralSecurityException e) {
            throw new CasperClientException("Error signing transaction", e);
        }
    }

    public AbstractTransaction() {
    }

    public AbstractTransaction(Digest hash, List<Approval> approvals) {
        this.hash = hash;
        this.approvals = approvals;
    }

    public Digest getHash() {
        return this.hash;
    }

    public List<Approval> getApprovals() {
        return this.approvals;
    }

    @JsonProperty(value="hash")
    public void setHash(Digest hash) {
        this.hash = hash;
    }

    @JsonProperty(value="approvals")
    public void setApprovals(List<Approval> approvals) {
        this.approvals = approvals;
    }
}

