/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.transaction;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.AbstractCLValue;
import com.casper.sdk.model.clvalue.CLValueOption;
import com.casper.sdk.model.clvalue.CLValueU64;
import com.casper.sdk.model.clvalue.serde.CasperSerializableObject;
import com.casper.sdk.model.clvalue.serde.Target;
import com.casper.sdk.model.deploy.NamedArg;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class NamedArgs
implements Iterable<NamedArg<?>>,
CasperSerializableObject {
    public static final String ID = "id";
    @JsonProperty(value="Named")
    private final List<NamedArg<?>> args = new ArrayList();

    public NamedArgs(List<NamedArg<?>> args) {
        if (args != null) {
            this.args.addAll(args);
        }
    }

    public NamedArgs(NamedArg<?> ... args) {
        if (args != null) {
            for (NamedArg<?> arg : args) {
                this.add(arg);
            }
        }
    }

    public NamedArgs add(NamedArg<?> namedArg) {
        this.args.add(namedArg);
        return this;
    }

    public int size() {
        return this.args.size();
    }

    public NamedArg<?> get(String name) {
        for (NamedArg<?> arg : this.args) {
            if (!name.equals(arg.getType())) continue;
            return arg;
        }
        return null;
    }

    @Override
    @NotNull
    public Iterator<NamedArg<?>> iterator() {
        return this.args.iterator();
    }

    public NamedArg<?> get(int index) {
        return this.args.get(index);
    }

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws ValueSerializationException, NoSuchTypeException {
        ser.writeU8((byte)0);
        ser.writeI32(this.args.size());
        for (NamedArg<?> namedArg : this.args) {
            if (ID.equals(namedArg.getType())) {
                this.validateId(namedArg.getClValue());
            }
            namedArg.serialize(ser, Target.BYTE);
        }
    }

    private void validateId(AbstractCLValue<?, ?> idNamedArgValue) {
        if (!(idNamedArgValue instanceof CLValueOption)) {
            throw new IllegalArgumentException("NamedArg type 'id' must be of type CLValueOption");
        }
        CLValueOption id = (CLValueOption)idNamedArgValue;
        if (((Optional)id.getValue()).isPresent() && !(((Optional)id.getValue()).get() instanceof CLValueU64)) {
            throw new IllegalArgumentException("NamedArg type 'id' must be of type CLValueOption(CLValueU64)");
        }
    }

    public NamedArgs() {
    }

    public List<NamedArg<?>> getArgs() {
        return this.args;
    }
}

