/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.transaction;

import com.casper.sdk.exception.CasperClientException;
import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.serde.CasperSerializableObject;
import com.casper.sdk.model.clvalue.serde.Target;
import com.casper.sdk.model.common.Digest;
import com.casper.sdk.model.deploy.Approval;
import com.casper.sdk.model.transaction.AbstractTransaction;
import com.casper.sdk.model.transaction.TransactionV1Payload;
import com.casper.sdk.model.transaction.field.CalltableSerializationEnvelopeBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import java.util.List;

@JsonPropertyOrder(value={"hash", "payload", "approvals"})
public class TransactionV1
extends AbstractTransaction
implements CasperSerializableObject {
    private static final int HASH_FIELD_INDEX = 0;
    private static final int PAYLOAD_FIELD_INDEX = 1;
    private static final int APPROVALS_FIELD_INDEX = 2;
    @JsonProperty(value="payload")
    private TransactionV1Payload payload;

    public TransactionV1(Digest hash, TransactionV1Payload payload, List<Approval> approvals) {
        super(hash, approvals);
        this.payload = payload;
    }

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws ValueSerializationException, NoSuchTypeException {
        new CalltableSerializationEnvelopeBuilder(target).addField(0, this.getHash()).addField(1, this.payload).addField(2, this.getApprovals()).serialize(ser, target);
    }

    @Override
    public void calculateHash() {
        try {
            this.setHash(this.payload.buildHash());
        }
        catch (Exception e) {
            throw new CasperClientException("Error calculating hash", e);
        }
    }

    public static TransactionV1Builder builder() {
        return new TransactionV1Builder();
    }

    public TransactionV1() {
    }

    public TransactionV1(TransactionV1Payload payload) {
        this.payload = payload;
    }

    public TransactionV1Payload getPayload() {
        return this.payload;
    }

    @JsonProperty(value="payload")
    public void setPayload(TransactionV1Payload payload) {
        this.payload = payload;
    }

    public static class TransactionV1Builder {
        private TransactionV1Payload payload;
        private Digest hash;
        private List<Approval> approvals;

        TransactionV1Builder() {
        }

        @JsonProperty(value="payload")
        public TransactionV1Builder payload(TransactionV1Payload payload) {
            this.payload = payload;
            return this;
        }

        public TransactionV1 build() {
            return new TransactionV1(this.payload);
        }

        public String toString() {
            return "TransactionV1.TransactionV1Builder(payload=" + this.payload + ")";
        }

        public TransactionV1Builder hash(Digest hash) {
            this.hash = hash;
            return this;
        }

        public TransactionV1Builder approvals(List<Approval> approvals) {
            this.approvals = approvals;
            return this;
        }
    }
}

