/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.transaction;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.serde.CasperSerializableObject;
import com.casper.sdk.model.clvalue.serde.Target;
import com.casper.sdk.model.common.Digest;
import com.casper.sdk.model.common.Ttl;
import com.casper.sdk.model.key.Tag;
import com.casper.sdk.model.transaction.InitiatorAddr;
import com.casper.sdk.model.transaction.entrypoint.TransactionEntryPoint;
import com.casper.sdk.model.transaction.field.CalltableSerializationEnvelopeBuilder;
import com.casper.sdk.model.transaction.field.Fields;
import com.casper.sdk.model.transaction.pricing.PricingMode;
import com.casper.sdk.model.transaction.scheduling.TransactionScheduling;
import com.casper.sdk.model.transaction.target.TransactionTarget;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import java.util.Date;

public class TransactionV1Payload
implements CasperSerializableObject,
Tag {
    private static final int INITIATOR_ADDR_FIELD_INDEX = 0;
    private static final int TIMESTAMP_FIELD_INDEX = 1;
    private static final int TTL_FIELD_INDEX = 2;
    private static final int CHAIN_NAME_FIELD_INDEX = 3;
    private static final int PRICING_MODE_FIELD_INDEX = 4;
    private static final int FIELDS_FIELD_INDEX = 5;
    @JsonProperty(value="initiator_addr")
    private InitiatorAddr initiatorAddr;
    @JsonProperty(value="timestamp")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date timestamp;
    @JsonProperty(value="ttl")
    private Ttl ttl;
    @JsonProperty(value="chain_name")
    private String chainName;
    @JsonProperty(value="pricing_mode")
    private PricingMode pricingMode;
    @JsonProperty(value="fields")
    private Fields fields;

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws ValueSerializationException, NoSuchTypeException {
        new CalltableSerializationEnvelopeBuilder(target).addField(0, this.initiatorAddr).addField(1, this.timestamp != null ? this.timestamp.getTime() : new Date().getTime()).addField(2, this.ttl.getTtl()).addField(3, this.chainName).addField(4, this.pricingMode).addField(5, this.fields).serialize(ser, target);
    }

    @Override
    @JsonIgnore
    public byte getByteTag() {
        return 1;
    }

    public void setTarget(TransactionTarget target) {
        this.getFields().setTarget(target);
    }

    public void setEntryPoint(TransactionEntryPoint entryPoint) {
        this.getFields().setEntryPoint(entryPoint);
    }

    public void setScheduling(TransactionScheduling scheduling) {
        this.getFields().setScheduling(scheduling);
    }

    public Digest buildHash() throws NoSuchTypeException, ValueSerializationException {
        SerializerBuffer serializerBuffer = new SerializerBuffer();
        this.serialize(serializerBuffer, Target.BYTE);
        byte[] bytes = serializerBuffer.toByteArray();
        return Digest.blake2bDigestFromBytes(bytes);
    }

    private static Fields $default$fields() {
        return new Fields();
    }

    public static TransactionV1PayloadBuilder builder() {
        return new TransactionV1PayloadBuilder();
    }

    public TransactionV1Payload() {
        this.fields = TransactionV1Payload.$default$fields();
    }

    public TransactionV1Payload(InitiatorAddr initiatorAddr, Date timestamp, Ttl ttl, String chainName, PricingMode pricingMode, Fields fields) {
        this.initiatorAddr = initiatorAddr;
        this.timestamp = timestamp;
        this.ttl = ttl;
        this.chainName = chainName;
        this.pricingMode = pricingMode;
        this.fields = fields;
    }

    public InitiatorAddr getInitiatorAddr() {
        return this.initiatorAddr;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Ttl getTtl() {
        return this.ttl;
    }

    public String getChainName() {
        return this.chainName;
    }

    public PricingMode getPricingMode() {
        return this.pricingMode;
    }

    public Fields getFields() {
        return this.fields;
    }

    @JsonProperty(value="initiator_addr")
    public void setInitiatorAddr(InitiatorAddr initiatorAddr) {
        this.initiatorAddr = initiatorAddr;
    }

    @JsonProperty(value="timestamp")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    @JsonProperty(value="ttl")
    public void setTtl(Ttl ttl) {
        this.ttl = ttl;
    }

    @JsonProperty(value="chain_name")
    public void setChainName(String chainName) {
        this.chainName = chainName;
    }

    @JsonProperty(value="pricing_mode")
    public void setPricingMode(PricingMode pricingMode) {
        this.pricingMode = pricingMode;
    }

    @JsonProperty(value="fields")
    public void setFields(Fields fields) {
        this.fields = fields;
    }

    public static class TransactionV1PayloadBuilder {
        private InitiatorAddr initiatorAddr;
        private Date timestamp;
        private Ttl ttl;
        private String chainName;
        private PricingMode pricingMode;
        private boolean fields$set;
        private Fields fields$value;

        TransactionV1PayloadBuilder() {
        }

        @JsonProperty(value="initiator_addr")
        public TransactionV1PayloadBuilder initiatorAddr(InitiatorAddr initiatorAddr) {
            this.initiatorAddr = initiatorAddr;
            return this;
        }

        @JsonProperty(value="timestamp")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
        public TransactionV1PayloadBuilder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="ttl")
        public TransactionV1PayloadBuilder ttl(Ttl ttl) {
            this.ttl = ttl;
            return this;
        }

        @JsonProperty(value="chain_name")
        public TransactionV1PayloadBuilder chainName(String chainName) {
            this.chainName = chainName;
            return this;
        }

        @JsonProperty(value="pricing_mode")
        public TransactionV1PayloadBuilder pricingMode(PricingMode pricingMode) {
            this.pricingMode = pricingMode;
            return this;
        }

        @JsonProperty(value="fields")
        public TransactionV1PayloadBuilder fields(Fields fields) {
            this.fields$value = fields;
            this.fields$set = true;
            return this;
        }

        public TransactionV1Payload build() {
            Fields fields$value = this.fields$value;
            if (!this.fields$set) {
                fields$value = TransactionV1Payload.$default$fields();
            }
            return new TransactionV1Payload(this.initiatorAddr, this.timestamp, this.ttl, this.chainName, this.pricingMode, fields$value);
        }

        public String toString() {
            return "TransactionV1Payload.TransactionV1PayloadBuilder(initiatorAddr=" + this.initiatorAddr + ", timestamp=" + this.timestamp + ", ttl=" + this.ttl + ", chainName=" + this.chainName + ", pricingMode=" + this.pricingMode + ", fields$value=" + this.fields$value + ")";
        }
    }
}

