/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.transaction.entrypoint;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.jackson.deserializer.TransactionEntryPointDeserializer;
import com.casper.sdk.jackson.serializer.TransactionEntryPointSerializer;
import com.casper.sdk.model.clvalue.serde.CasperSerializableObject;
import com.casper.sdk.model.clvalue.serde.Target;
import com.casper.sdk.model.key.Tag;
import com.casper.sdk.model.transaction.field.CalltableSerializationEnvelopeBuilder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;

@JsonSerialize(using=TransactionEntryPointSerializer.class)
@JsonDeserialize(using=TransactionEntryPointDeserializer.class)
public abstract class TransactionEntryPoint
implements CasperSerializableObject,
Tag {
    protected static final int TAG_FIELD_INDEX = 0;
    protected static final int CUSTOM_CUSTOM_INDEX = 1;
    protected static final int CALL_TAG = 0;
    protected static final int CUSTOM_TAG = 1;
    protected static final int TRANSFER_TAG = 2;
    protected static final int ADD_BID_TAG = 3;
    protected static final int WITHDRAW_BID_TAG = 4;
    protected static final int DELEGATE_TAG = 5;
    protected static final int UNDELEGATE_TAG = 6;
    protected static final int REDELEGATE_TAG = 7;
    protected static final int ACTIVATE_BID_TAG = 8;
    protected static final int CHANGE_BID_PUBLIC_KEY_TAG = 9;
    protected static final int ADD_RESERVATIONS_TAG = 10;
    protected static final int CANCEL_RESERVATIONS_TAG = 11;
    private final byte tag;
    private final String name;

    @Override
    public byte getByteTag() {
        return this.tag;
    }

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws ValueSerializationException, NoSuchTypeException {
        new CalltableSerializationEnvelopeBuilder(target).addField(0, this.getTag()).serialize(ser, target);
    }

    public String toString() {
        return this.name;
    }

    public TransactionEntryPoint(byte tag, String name) {
        this.tag = tag;
        this.name = name;
    }

    public TransactionEntryPoint() {
        this.tag = 0;
        this.name = null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionEntryPoint)) {
            return false;
        }
        TransactionEntryPoint other = (TransactionEntryPoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTag() != other.getTag()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionEntryPoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTag();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public byte getTag() {
        return this.tag;
    }

    public String getName() {
        return this.name;
    }
}

