/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.transaction.field;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.serde.CasperSerializableObject;
import com.casper.sdk.model.clvalue.serde.Target;
import com.casper.sdk.model.transaction.field.Field;
import com.syntifi.crypto.key.encdec.Hex;
import dev.oak3.sbs4j.DeserializerBuffer;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueDeserializationException;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import dev.oak3.sbs4j.interfaces.DeserializableObject;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalltableSerializationEnvelopeBuilder
implements CasperSerializableObject,
DeserializableObject {
    private final Logger logger = LoggerFactory.getLogger(CalltableSerializationEnvelopeBuilder.class);
    private List<Field> fields = new ArrayList<Field>();
    private long currentFieldIndex = -1L;
    private long offset = 0L;
    private long size = 0L;
    private Target target;

    public CalltableSerializationEnvelopeBuilder(Target target) {
        this.target = target;
    }

    public <T> CalltableSerializationEnvelopeBuilder addField(int index, T value) throws ValueSerializationException, NoSuchTypeException {
        if (value != null) {
            return this.addField(new Field(index, this.offset, false, value, this.target));
        }
        return this;
    }

    public <T> CasperSerializableObject addOptionField(int index, T value) throws ValueSerializationException, NoSuchTypeException {
        return this.addField(new Field(index, this.offset, true, value, this.target));
    }

    public CalltableSerializationEnvelopeBuilder addFieldBytes(int index, byte[] value) {
        if (value != null) {
            return this.addField(new Field(index, this.offset, value));
        }
        return this;
    }

    public CalltableSerializationEnvelopeBuilder addField(Field field) {
        if (this.currentFieldIndex >= (long)field.getIndex()) {
            throw new IllegalArgumentException("Field index must be greater than the previous field index");
        }
        this.fields.add(field);
        this.currentFieldIndex = field.getIndex();
        this.size += (long)field.getValue().length;
        this.offset += (long)field.getValue().length;
        return this;
    }

    public <T> T getFieldValue(int index, Class<T> clazz) throws ValueDeserializationException {
        Field field = this.fields.get(index);
        return field.getValue(clazz);
    }

    public byte[] getFieldBytes(int index) {
        return this.fields.get(index).getValue();
    }

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws ValueSerializationException {
        SerializerBuffer fieldsSer = new SerializerBuffer();
        fieldsSer.writeU32(Long.valueOf(this.fields.size()));
        for (Field field : this.fields) {
            field.serialize(fieldsSer, target);
        }
        fieldsSer.writeU32(this.size);
        for (Field field : this.fields) {
            fieldsSer.writeByteArray(field.getValue());
        }
        byte[] byteArray = fieldsSer.toByteArray();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("CalltableSerializationEnvelopeBuilder bytes {} {} {}", new Object[]{this.size, String.format("0x%04X", this.size), Hex.encode(byteArray)});
        }
        ser.writeByteArray(byteArray);
    }

    @Override
    public void deserialize(DeserializerBuffer deserializerBuffer) throws ValueDeserializationException {
        long numFields = deserializerBuffer.readU32();
        int i = 0;
        while ((long)i < numFields) {
            Field field = new Field();
            field.deserialize(deserializerBuffer);
            this.fields.add(field);
            ++i;
        }
        this.size = deserializerBuffer.readU32();
        for (Field field : this.fields) {
            long fieldValueLen = this.getFieldLength(field);
            field.setValue(deserializerBuffer.readByteArray((int)fieldValueLen));
        }
    }

    private long getFieldLength(Field field) {
        if (field.getIndex() == this.fields.size() - 1) {
            return this.size - field.getOffset();
        }
        return this.fields.get(field.getIndex() + 1).getOffset() - field.getOffset();
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public void setCurrentFieldIndex(long currentFieldIndex) {
        this.currentFieldIndex = currentFieldIndex;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setTarget(Target target) {
        this.target = target;
    }
}

