/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.transaction.field;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.serde.CasperSerializableObject;
import com.casper.sdk.model.clvalue.serde.Target;
import com.syntifi.crypto.key.encdec.Hex;
import dev.oak3.sbs4j.DeserializerBuffer;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueDeserializationException;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import dev.oak3.sbs4j.interfaces.DeserializableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Field
implements CasperSerializableObject,
DeserializableObject {
    private final Logger logger = LoggerFactory.getLogger(Field.class);
    private short index;
    private long offset;
    private byte[] value;
    private boolean optional;

    public Field(int index, long offset, byte[] value) {
        this.index = (short)index;
        this.offset = offset;
        this.value = value;
    }

    public Field(int index, long offset, boolean optional, Object value, Target target) throws ValueSerializationException, NoSuchTypeException {
        SerializerBuffer serializerBuffer = new SerializerBuffer();
        if (optional) {
            serializerBuffer.writeBool(value != null);
        }
        if (value != null) {
            if (value instanceof CasperSerializableObject) {
                ((CasperSerializableObject)value).serialize(serializerBuffer, target);
            } else if (value instanceof Boolean) {
                serializerBuffer.writeBool((Boolean)value);
            } else if (value instanceof byte[]) {
                serializerBuffer.writeByteArray((byte[])value);
            } else if (value.getClass().equals(Byte.class)) {
                serializerBuffer.writeU8((Byte)value);
            } else if (value.getClass().equals(Long.class)) {
                serializerBuffer.writeI64((Long)value);
            } else if (value.getClass().equals(Integer.class)) {
                serializerBuffer.writeI32((Integer)value);
            } else if (value.getClass().equals(Short.class)) {
                serializerBuffer.writeU16((Short)value);
            } else if (value.getClass().equals(String.class)) {
                serializerBuffer.writeString((String)value);
            } else {
                throw new ValueSerializationException("Unsupported type " + value.getClass().getName());
            }
        }
        this.index = (short)index;
        this.offset = offset;
        this.optional = optional;
        this.value = serializerBuffer.toByteArray();
    }

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws ValueSerializationException {
        this.serialize(ser);
    }

    @Override
    public void serialize(SerializerBuffer ser) throws ValueSerializationException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Serializing field index: {}, offset: {} {}, len: {}, value: {}", new Object[]{this.index, this.offset, String.format("0x%02X", this.offset), this.value.length, Hex.encode(this.value)});
        }
        ser.writeU16(this.index);
        ser.writeU32(this.offset);
    }

    @Override
    public void deserialize(DeserializerBuffer deser) throws ValueDeserializationException {
        this.index = deser.readU16();
        this.offset = deser.readU32();
    }

    public <T> T getValue(Class<T> clazz) throws ValueDeserializationException {
        DeserializerBuffer deserializerBuffer = new DeserializerBuffer(this.value);
        if (clazz.isAssignableFrom(DeserializableObject.class)) {
            try {
                T value = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ((DeserializableObject)value).deserialize(deserializerBuffer);
                return value;
            }
            catch (Exception e) {
                throw new ValueDeserializationException("Unsupported type " + clazz.getName(), e);
            }
        }
        if (clazz == Boolean.class) {
            return (T)deserializerBuffer.readBool();
        }
        if (clazz == byte[].class) {
            return (T)deserializerBuffer.readByteArray(this.value.length);
        }
        if (clazz == Byte.class) {
            return (T)Byte.valueOf(deserializerBuffer.readU8());
        }
        if (clazz == Long.class) {
            return (T)Long.valueOf(deserializerBuffer.readU32());
        }
        if (clazz == Integer.class) {
            return (T)Integer.valueOf(deserializerBuffer.readI32());
        }
        if (clazz == Short.class) {
            return (T)Short.valueOf(deserializerBuffer.readU16());
        }
        if (clazz == String.class) {
            return (T)deserializerBuffer.readString();
        }
        throw new IllegalArgumentException("Unsupported type " + clazz.getName());
    }

    public Field() {
    }

    public Logger getLogger() {
        return this.logger;
    }

    public short getIndex() {
        return this.index;
    }

    public long getOffset() {
        return this.offset;
    }

    public byte[] getValue() {
        return this.value;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setIndex(short index) {
        this.index = index;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }
}

