/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.transaction.pricing;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.serde.Target;
import com.casper.sdk.model.transaction.field.CalltableSerializationEnvelopeBuilder;
import com.casper.sdk.model.transaction.pricing.PricingMode;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;

public class FixedPricingMode
implements PricingMode {
    private static final int FIXED_GAS_PRICE_TOLERANCE_INDEX = 1;
    private static final int FIXED_ADDITIONAL_COMPUTATION_FACTOR_INDEX = 2;
    @JsonProperty(value="additional_computation_factor")
    private int additionalComputationFactor;
    @JsonProperty(value="gas_price_tolerance")
    private int gasPriceTolerance;

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws ValueSerializationException, NoSuchTypeException {
        new CalltableSerializationEnvelopeBuilder(target).addField(0, this.getByteTag()).addField(1, (byte)this.gasPriceTolerance).addField(2, (byte)this.additionalComputationFactor).serialize(ser, target);
    }

    @Override
    @JsonIgnore
    public byte getByteTag() {
        return 1;
    }

    public static FixedPricingModeBuilder builder() {
        return new FixedPricingModeBuilder();
    }

    public FixedPricingMode() {
    }

    public FixedPricingMode(int additionalComputationFactor, int gasPriceTolerance) {
        this.additionalComputationFactor = additionalComputationFactor;
        this.gasPriceTolerance = gasPriceTolerance;
    }

    public int getAdditionalComputationFactor() {
        return this.additionalComputationFactor;
    }

    public int getGasPriceTolerance() {
        return this.gasPriceTolerance;
    }

    @JsonProperty(value="additional_computation_factor")
    public void setAdditionalComputationFactor(int additionalComputationFactor) {
        this.additionalComputationFactor = additionalComputationFactor;
    }

    @JsonProperty(value="gas_price_tolerance")
    public void setGasPriceTolerance(int gasPriceTolerance) {
        this.gasPriceTolerance = gasPriceTolerance;
    }

    public static class FixedPricingModeBuilder {
        private int additionalComputationFactor;
        private int gasPriceTolerance;

        FixedPricingModeBuilder() {
        }

        @JsonProperty(value="additional_computation_factor")
        public FixedPricingModeBuilder additionalComputationFactor(int additionalComputationFactor) {
            this.additionalComputationFactor = additionalComputationFactor;
            return this;
        }

        @JsonProperty(value="gas_price_tolerance")
        public FixedPricingModeBuilder gasPriceTolerance(int gasPriceTolerance) {
            this.gasPriceTolerance = gasPriceTolerance;
            return this;
        }

        public FixedPricingMode build() {
            return new FixedPricingMode(this.additionalComputationFactor, this.gasPriceTolerance);
        }

        public String toString() {
            return "FixedPricingMode.FixedPricingModeBuilder(additionalComputationFactor=" + this.additionalComputationFactor + ", gasPriceTolerance=" + this.gasPriceTolerance + ")";
        }
    }
}

