/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.transaction.pricing;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.serde.Target;
import com.casper.sdk.model.transaction.field.CalltableSerializationEnvelopeBuilder;
import com.casper.sdk.model.transaction.pricing.PricingMode;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import java.math.BigInteger;

public class PaymentLimited
implements PricingMode {
    private static final int PAYMENT_LIMITED_PAYMENT_AMOUNT_INDEX = 1;
    private static final int PAYMENT_LIMITED_GAS_PRICE_TOLERANCE_INDEX = 2;
    private static final int PAYMENT_LIMITED_STANDARD_PAYMENT_INDEX = 3;
    @JsonProperty(value="payment_amount")
    private BigInteger paymentAmount;
    @JsonProperty(value="gas_price_tolerance")
    private int gasPriceTolerance;
    @JsonProperty(value="standard_payment")
    private boolean standardPayment;

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws ValueSerializationException, NoSuchTypeException {
        new CalltableSerializationEnvelopeBuilder(target).addField(0, this.getByteTag()).addField(1, this.paymentAmount.longValue()).addField(2, (byte)this.gasPriceTolerance).addField(3, this.standardPayment).serialize(ser, target);
    }

    @Override
    @JsonIgnore
    public byte getByteTag() {
        return 0;
    }

    public static PaymentLimitedBuilder builder() {
        return new PaymentLimitedBuilder();
    }

    public PaymentLimited() {
    }

    public PaymentLimited(BigInteger paymentAmount, int gasPriceTolerance, boolean standardPayment) {
        this.paymentAmount = paymentAmount;
        this.gasPriceTolerance = gasPriceTolerance;
        this.standardPayment = standardPayment;
    }

    public BigInteger getPaymentAmount() {
        return this.paymentAmount;
    }

    public int getGasPriceTolerance() {
        return this.gasPriceTolerance;
    }

    public boolean isStandardPayment() {
        return this.standardPayment;
    }

    @JsonProperty(value="payment_amount")
    public void setPaymentAmount(BigInteger paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    @JsonProperty(value="gas_price_tolerance")
    public void setGasPriceTolerance(int gasPriceTolerance) {
        this.gasPriceTolerance = gasPriceTolerance;
    }

    @JsonProperty(value="standard_payment")
    public void setStandardPayment(boolean standardPayment) {
        this.standardPayment = standardPayment;
    }

    public static class PaymentLimitedBuilder {
        private BigInteger paymentAmount;
        private int gasPriceTolerance;
        private boolean standardPayment;

        PaymentLimitedBuilder() {
        }

        @JsonProperty(value="payment_amount")
        public PaymentLimitedBuilder paymentAmount(BigInteger paymentAmount) {
            this.paymentAmount = paymentAmount;
            return this;
        }

        @JsonProperty(value="gas_price_tolerance")
        public PaymentLimitedBuilder gasPriceTolerance(int gasPriceTolerance) {
            this.gasPriceTolerance = gasPriceTolerance;
            return this;
        }

        @JsonProperty(value="standard_payment")
        public PaymentLimitedBuilder standardPayment(boolean standardPayment) {
            this.standardPayment = standardPayment;
            return this;
        }

        public PaymentLimited build() {
            return new PaymentLimited(this.paymentAmount, this.gasPriceTolerance, this.standardPayment);
        }

        public String toString() {
            return "PaymentLimited.PaymentLimitedBuilder(paymentAmount=" + this.paymentAmount + ", gasPriceTolerance=" + this.gasPriceTolerance + ", standardPayment=" + this.standardPayment + ")";
        }
    }
}

