/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.transaction.target;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.serde.Target;
import com.casper.sdk.model.common.Digest;
import com.casper.sdk.model.transaction.field.CalltableSerializationEnvelopeBuilder;
import com.casper.sdk.model.transaction.target.TransactionRuntime;
import com.casper.sdk.model.transaction.target.TransactionTarget;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import java.util.Objects;

@JsonTypeName(value="Session")
@JsonPropertyOrder(value={"installUpgrade", "runtime", "moduleBytes"})
public class Session
implements TransactionTarget {
    private final int TAG_FIELD_INDEX = 0;
    private final byte SESSION_TAG = (byte)2;
    private final int SESSION_IS_INSTALL_INDEX = 1;
    private final int SESSION_RUNTIME_INDEX = 2;
    private final int SESSION_MODULE_BYTES_INDEX = 3;
    private final int SESSION_TRANSFERRED_VALUE_INDEX = 4;
    private final int SESSION_SEED_INDEX = 5;
    @JsonProperty(value="is_install_upgrade")
    private boolean installUpgrade;
    @JsonProperty(value="runtime")
    private TransactionRuntime runtime;
    @JsonProperty(value="module_bytes")
    private byte[] moduleBytes;
    @JsonProperty(value="transferred_value")
    private long transferredValue;
    @JsonProperty(value="seed")
    private Digest seed;

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws ValueSerializationException, NoSuchTypeException {
        new CalltableSerializationEnvelopeBuilder(target).addField(0, this.getByteTag()).addField(1, this.isInstallUpgrade()).addField(2, this.getRuntime()).addField(3, this.getModuleBytes()).addField(4, this.getTransferredValue()).addOptionField(5, this.getSeed()).serialize(ser, target);
    }

    @Override
    @JsonIgnore
    public byte getByteTag() {
        return 2;
    }

    public Session() {
    }

    public int getTAG_FIELD_INDEX() {
        return this.TAG_FIELD_INDEX;
    }

    public byte getSESSION_TAG() {
        Objects.requireNonNull(this);
        return 2;
    }

    public int getSESSION_IS_INSTALL_INDEX() {
        return this.SESSION_IS_INSTALL_INDEX;
    }

    public int getSESSION_RUNTIME_INDEX() {
        Objects.requireNonNull(this);
        return 2;
    }

    public int getSESSION_MODULE_BYTES_INDEX() {
        return this.SESSION_MODULE_BYTES_INDEX;
    }

    public int getSESSION_TRANSFERRED_VALUE_INDEX() {
        return this.SESSION_TRANSFERRED_VALUE_INDEX;
    }

    public int getSESSION_SEED_INDEX() {
        return this.SESSION_SEED_INDEX;
    }

    public boolean isInstallUpgrade() {
        return this.installUpgrade;
    }

    public TransactionRuntime getRuntime() {
        return this.runtime;
    }

    public byte[] getModuleBytes() {
        return this.moduleBytes;
    }

    public long getTransferredValue() {
        return this.transferredValue;
    }

    public Digest getSeed() {
        return this.seed;
    }

    @JsonProperty(value="is_install_upgrade")
    public void setInstallUpgrade(boolean installUpgrade) {
        this.installUpgrade = installUpgrade;
    }

    @JsonProperty(value="runtime")
    public void setRuntime(TransactionRuntime runtime) {
        this.runtime = runtime;
    }

    @JsonProperty(value="module_bytes")
    public void setModuleBytes(byte[] moduleBytes) {
        this.moduleBytes = moduleBytes;
    }

    @JsonProperty(value="transferred_value")
    public void setTransferredValue(long transferredValue) {
        this.transferredValue = transferredValue;
    }

    @JsonProperty(value="seed")
    public void setSeed(Digest seed) {
        this.seed = seed;
    }

    public Session(boolean installUpgrade, TransactionRuntime runtime, byte[] moduleBytes, long transferredValue, Digest seed) {
        this.installUpgrade = installUpgrade;
        this.runtime = runtime;
        this.moduleBytes = moduleBytes;
        this.transferredValue = transferredValue;
        this.seed = seed;
    }
}

