/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.transaction.target;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.serde.Target;
import com.casper.sdk.model.transaction.field.CalltableSerializationEnvelopeBuilder;
import com.casper.sdk.model.transaction.target.TransactionInvocationTarget;
import com.casper.sdk.model.transaction.target.TransactionRuntime;
import com.casper.sdk.model.transaction.target.TransactionTarget;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;

@JsonTypeName(value="Stored")
public class Stored
implements TransactionTarget {
    private static final int TAG_FIELD_INDEX = 0;
    private static final int STORED_ID_INDEX = 1;
    private static final int STORED_RUNTIME_INDEX = 2;
    private TransactionInvocationTarget id;
    @JsonProperty(value="runtime")
    private TransactionRuntime runtime;
    @JsonProperty(value="transferred_value")
    private long transferredValue;

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws ValueSerializationException, NoSuchTypeException {
        new CalltableSerializationEnvelopeBuilder(target).addField(0, this.getByteTag()).addField(1, this.id).addField(2, this.runtime).serialize(ser, target);
    }

    @Override
    @JsonIgnore
    public byte getByteTag() {
        return 1;
    }

    public static StoredBuilder builder() {
        return new StoredBuilder();
    }

    public Stored() {
    }

    public Stored(TransactionInvocationTarget id, TransactionRuntime runtime, long transferredValue) {
        this.id = id;
        this.runtime = runtime;
        this.transferredValue = transferredValue;
    }

    public TransactionInvocationTarget getId() {
        return this.id;
    }

    public TransactionRuntime getRuntime() {
        return this.runtime;
    }

    public long getTransferredValue() {
        return this.transferredValue;
    }

    public void setId(TransactionInvocationTarget id) {
        this.id = id;
    }

    @JsonProperty(value="runtime")
    public void setRuntime(TransactionRuntime runtime) {
        this.runtime = runtime;
    }

    @JsonProperty(value="transferred_value")
    public void setTransferredValue(long transferredValue) {
        this.transferredValue = transferredValue;
    }

    public static class StoredBuilder {
        private TransactionInvocationTarget id;
        private TransactionRuntime runtime;
        private long transferredValue;

        StoredBuilder() {
        }

        public StoredBuilder id(TransactionInvocationTarget id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="runtime")
        public StoredBuilder runtime(TransactionRuntime runtime) {
            this.runtime = runtime;
            return this;
        }

        @JsonProperty(value="transferred_value")
        public StoredBuilder transferredValue(long transferredValue) {
            this.transferredValue = transferredValue;
            return this;
        }

        public Stored build() {
            return new Stored(this.id, this.runtime, this.transferredValue);
        }

        public String toString() {
            return "Stored.StoredBuilder(id=" + this.id + ", runtime=" + this.runtime + ", transferredValue=" + this.transferredValue + ")";
        }
    }
}

