/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.transaction.target;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.serde.CasperSerializableObject;
import com.casper.sdk.model.clvalue.serde.Target;
import com.casper.sdk.model.key.Tag;
import com.casper.sdk.model.transaction.field.CalltableSerializationEnvelopeBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;

public enum TransactionRuntime implements CasperSerializableObject,
Tag
{
    VM_CASPER_V1(0, "VmCasperV1"),
    VM_CASPER_V2(1, "VmCasperV2");

    private static final int TAG_FIELD_INDEX = 0;
    private final byte tag;
    private final String jsonName;

    private TransactionRuntime(int tag, String jsonName) {
        this.tag = (byte)tag;
        this.jsonName = jsonName;
    }

    @Override
    @JsonIgnore
    public byte getByteTag() {
        return this.tag;
    }

    public static String toJson(TransactionRuntime runtime) {
        return runtime != null ? runtime.jsonName : null;
    }

    public static TransactionRuntime fromJson(String name) throws NoSuchTypeException {
        for (TransactionRuntime t : TransactionRuntime.values()) {
            if (!t.jsonName.equals(name)) continue;
            return t;
        }
        throw new NoSuchTypeException(name);
    }

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws ValueSerializationException, NoSuchTypeException {
        new CalltableSerializationEnvelopeBuilder(target).addField(0, this.getByteTag()).serialize(ser, target);
    }

    public byte getTag() {
        return this.tag;
    }

    public String getJsonName() {
        return this.jsonName;
    }
}

