/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service;

import com.casper.sdk.exception.CasperClientExceptionResolver;
import com.casper.sdk.identifier.block.BlockIdentifier;
import com.casper.sdk.identifier.dictionary.DictionaryIdentifier;
import com.casper.sdk.identifier.entity.EntityIdentifier;
import com.casper.sdk.identifier.era.EraIdentifier;
import com.casper.sdk.identifier.global.GlobalStateIdentifier;
import com.casper.sdk.identifier.purse.PurseIdentifier;
import com.casper.sdk.model.account.AccountData;
import com.casper.sdk.model.auction.AuctionData;
import com.casper.sdk.model.balance.GetBalanceData;
import com.casper.sdk.model.balance.QueryBalanceData;
import com.casper.sdk.model.balance.QueryBalanceDetailsResult;
import com.casper.sdk.model.block.ChainGetBlockResult;
import com.casper.sdk.model.deploy.Deploy;
import com.casper.sdk.model.deploy.DeployData;
import com.casper.sdk.model.deploy.DeployResult;
import com.casper.sdk.model.deploy.SpeculativeDeployData;
import com.casper.sdk.model.dictionary.DictionaryData;
import com.casper.sdk.model.entity.StateEntityResult;
import com.casper.sdk.model.era.EraInfoData;
import com.casper.sdk.model.globalstate.GlobalStateData;
import com.casper.sdk.model.key.PublicKey;
import com.casper.sdk.model.peer.PeerData;
import com.casper.sdk.model.reward.GetRewardResult;
import com.casper.sdk.model.stateroothash.StateRootHashData;
import com.casper.sdk.model.status.ChainspecData;
import com.casper.sdk.model.status.StatusData;
import com.casper.sdk.model.storedvalue.StoredValueData;
import com.casper.sdk.model.transaction.GetTransactionResult;
import com.casper.sdk.model.transaction.PutTransactionResult;
import com.casper.sdk.model.transaction.TransactionHash;
import com.casper.sdk.model.transaction.target.Transaction;
import com.casper.sdk.model.transfer.TransferData;
import com.casper.sdk.model.uref.URef;
import com.casper.sdk.model.validator.ValidatorChangeData;
import com.casper.sdk.service.CasperObjectMapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.ExceptionResolver;
import com.googlecode.jsonrpc4j.IJsonRpcClient;
import com.googlecode.jsonrpc4j.JsonRpcHttpClient;
import com.googlecode.jsonrpc4j.JsonRpcMethod;
import com.googlecode.jsonrpc4j.JsonRpcParam;
import com.googlecode.jsonrpc4j.JsonRpcParamsPassMode;
import com.googlecode.jsonrpc4j.ProxyUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.common.util.StringUtils;

public interface CasperService {
    public static CasperService usingPeer(URL url, Map<String, String> additionalHeaders) throws MalformedURLException {
        if (StringUtils.isEmpty((String)url.getPath())) {
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), "/rpc");
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        if (additionalHeaders != null) {
            headers.putAll(additionalHeaders);
        }
        JsonRpcHttpClient client = new JsonRpcHttpClient((ObjectMapper)new CasperObjectMapper(), url, headers);
        client.setExceptionResolver((ExceptionResolver)new CasperClientExceptionResolver());
        return (CasperService)ProxyUtil.createClientProxy((ClassLoader)CasperService.class.getClassLoader(), CasperService.class, (IJsonRpcClient)client);
    }

    public static CasperService usingPeer(String ip, int port) throws MalformedURLException {
        return CasperService.usingPeer(new URL("http", ip, port, "/rpc"), null);
    }

    @JsonRpcMethod(value="chain_get_block")
    public ChainGetBlockResult getBlock();

    @JsonRpcMethod(value="chain_get_block")
    public ChainGetBlockResult getBlock(@JsonRpcParam(value="block_identifier") BlockIdentifier var1);

    @JsonRpcMethod(value="chain_get_block_transfers")
    public TransferData getBlockTransfers();

    @JsonRpcMethod(value="chain_get_block_transfers")
    public TransferData getBlockTransfers(@JsonRpcParam(value="block_identifier") BlockIdentifier var1);

    @JsonRpcMethod(value="chain_get_state_root_hash")
    public StateRootHashData getStateRootHash();

    @JsonRpcMethod(value="chain_get_state_root_hash")
    public StateRootHashData getStateRootHash(@JsonRpcParam(value="block_identifier") BlockIdentifier var1);

    @JsonRpcMethod(value="info_get_deploy")
    public DeployData getDeploy(@JsonRpcParam(value="deploy_hash") String var1);

    @JsonRpcMethod(value="info_get_transaction")
    public GetTransactionResult getTransaction(@JsonRpcParam(value="transaction_hash") TransactionHash var1);

    @JsonRpcMethod(value="query_global_state")
    public GlobalStateData queryGlobalState(@JsonRpcParam(value="state_identifier") GlobalStateIdentifier var1, @JsonRpcParam(value="key") String var2, @JsonRpcParam(value="path") String[] var3);

    @JsonRpcMethod(value="query_balance_details")
    public QueryBalanceDetailsResult queryBalanceDetails(@JsonRpcParam(value="purse_identifier") PurseIdentifier var1, @JsonRpcParam(value="state_identifier") GlobalStateIdentifier var2);

    @JsonRpcMethod(value="state_get_balance")
    public GetBalanceData getBalance(@JsonRpcParam(value="state_root_hash") String var1, @JsonRpcParam(value="purse_uref") URef var2);

    @JsonRpcMethod(value="state_get_dictionary_item")
    public DictionaryData getStateDictionaryItem(@JsonRpcParam(value="state_root_hash") String var1, @JsonRpcParam(value="dictionary_identifier") DictionaryIdentifier var2);

    @JsonRpcMethod(value="info_get_peers")
    public PeerData getPeerData();

    @JsonRpcMethod(value="info_get_status")
    public StatusData getStatus();

    @JsonRpcMethod(value="state_get_entity")
    public StateEntityResult getStateEntity(@JsonRpcParam(value="entity_identifier") EntityIdentifier var1, @JsonRpcParam(value="block_identifier") BlockIdentifier var2);

    @JsonRpcMethod(value="info_get_reward")
    public GetRewardResult getReward(@JsonRpcParam(value="era_identifier") EraIdentifier var1, @JsonRpcParam(value="validator") PublicKey var2, @JsonRpcParam(value="delegator") PublicKey var3);

    @JsonRpcMethod(value="account_put_transaction", paramsPassMode=JsonRpcParamsPassMode.ARRAY)
    public PutTransactionResult putTransaction(Transaction var1);

    @JsonRpcMethod(value="speculative_exec")
    public SpeculativeDeployData speculativeExec(@JsonRpcParam(value="block_identifier") BlockIdentifier var1, @JsonRpcParam(value="deploy") Deploy var2);

    @JsonRpcMethod(value="speculative_exec")
    public SpeculativeDeployData speculativeExec(@JsonRpcParam(value="deploy") Deploy var1);

    @JsonRpcMethod(value="state_get_auction_info")
    public AuctionData getStateAuctionInfo(@JsonRpcParam(value="block_identifier") BlockIdentifier var1);

    @JsonRpcMethod(value="info_get_validator_changes")
    public ValidatorChangeData getValidatorsChanges();

    @JsonRpcMethod(value="chain_get_era_info_by_switch_block")
    public EraInfoData getEraInfoBySwitchBlock(@JsonRpcParam(value="block_identifier") BlockIdentifier var1);

    @JsonRpcMethod(value="chain_get_era_summary")
    public EraInfoData getEraSummary(@JsonRpcParam(value="block_identifier") BlockIdentifier var1);

    @JsonRpcMethod(value="query_balance")
    public QueryBalanceData queryBalance(@JsonRpcParam(value="state_identifier") GlobalStateIdentifier var1, @JsonRpcParam(value="purse_identifier") PurseIdentifier var2);

    @JsonRpcMethod(value="info_get_chainspec")
    public ChainspecData getChainspec();

    @Deprecated
    @JsonRpcMethod(value="state_get_item")
    public StoredValueData getStateItem(@JsonRpcParam(value="state_root_hash") String var1, @JsonRpcParam(value="key") String var2, @JsonRpcParam(value="path") List<String> var3);

    @Deprecated
    @JsonRpcMethod(value="account_put_deploy", paramsPassMode=JsonRpcParamsPassMode.ARRAY)
    public DeployResult putDeploy(Deploy var1);

    @Deprecated
    @JsonRpcMethod(value="state_get_account_info")
    public AccountData getStateAccountInfo(@JsonRpcParam(value="account_identifier") String var1, @JsonRpcParam(value="block_identifier") BlockIdentifier var2);
}

