/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.impl.event;

import com.casper.sdk.exception.CasperClientException;
import com.casper.sdk.model.event.Event;
import com.casper.sdk.model.event.EventData;
import com.casper.sdk.model.event.EventTarget;
import com.casper.sdk.model.event.shutdown.Shutdown;
import com.casper.sdk.service.impl.event.AbstractEvent;
import com.casper.sdk.service.impl.event.EventRoot;
import com.casper.sdk.service.impl.event.PojoEvent;
import com.casper.sdk.service.impl.event.RawEvent;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.jetbrains.annotations.NotNull;

final class EventBuilder {
    public static final String API_VERSION = "ApiVersion";
    public static final String SHUTDOWN = "\"Shutdown\"";
    private Long id;
    private String data;
    private final EventTarget eventTarget;
    private final String source;
    private boolean idExpected = true;
    private final ObjectMapper mapper;
    private String version;

    EventBuilder(EventTarget eventTarget, String source) {
        this.eventTarget = eventTarget;
        this.source = source;
        this.mapper = new ObjectMapper();
    }

    boolean isComplete() {
        return (this.id != null || !this.idExpected) && this.data != null;
    }

    boolean processLine(String id, String data) {
        try {
            String trimmed = data.trim();
            if (data.startsWith("{")) {
                this.data = trimmed;
                this.id = this.getId(id);
                this.idExpected = this.isIdExpected(trimmed);
            }
            if (this.isApiVersion(trimmed)) {
                this.version = this.getVersion(trimmed);
            }
            return this.isComplete();
        }
        catch (Exception e) {
            throw new CasperClientException(e.getMessage(), e);
        }
    }

    private String getVersion(String line) {
        return line.replace("{\"ApiVersion\":\"", "").replace("\"}", "");
    }

    private boolean isIdExpected(String line) {
        return !this.isApiVersion(line);
    }

    private Long getId(String id) {
        return id != null ? Long.valueOf(id) : null;
    }

    private boolean isApiVersion(String line) {
        return line.contains(API_VERSION);
    }

    <T extends Event> T buildEvent() {
        AbstractEvent event;
        if (this.eventTarget == EventTarget.RAW) {
            event = new RawEvent(this.source, this.id, this.data, this.version);
        } else if (this.eventTarget == EventTarget.POJO) {
            event = this.buildPojoEvent();
        } else {
            throw new IllegalArgumentException("Unsupported eventTarget: " + (Object)((Object)this.eventTarget));
        }
        this.reset();
        return (T)event;
    }

    @NotNull
    private <T extends EventData> PojoEvent<T> buildPojoEvent() {
        PojoEvent event;
        try {
            String value = this.data.trim();
            EventRoot root = SHUTDOWN.equals(value) ? new EventRoot(new Shutdown()) : (EventRoot)this.mapper.readValue(value, EventRoot.class);
            event = new PojoEvent(this.source, this.id, EventRoot.getData(root), this.version);
        }
        catch (JsonProcessingException e) {
            throw new CasperClientException("Error building POJO event for: " + this.data, e);
        }
        return event;
    }

    private void reset() {
        this.data = null;
        this.id = null;
        this.idExpected = true;
    }
}

