/*
 * Decompiled with CFR 0.152.
 */
package dev.oak3.sbs4j;

import dev.oak3.sbs4j.exception.NoSuchTypeException;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import dev.oak3.sbs4j.util.ByteUtils;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializerBuffer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializerBuffer.class);
    private ByteBuffer buffer;
    private static final int INITIAL_CAPACITY = 4096;
    public static final BigInteger ZERO = new BigInteger("0", 10);
    public static final BigInteger ONE = new BigInteger("1", 10);
    public static final BigInteger TWO = new BigInteger("2", 10);
    public static final BigInteger MAX_U64 = TWO.pow(64).subtract(ONE);
    public static final BigInteger MAX_U128 = TWO.pow(128).subtract(ONE);
    public static final BigInteger MAX_U256 = TWO.pow(256).subtract(ONE);
    public static final BigInteger MAX_U512 = TWO.pow(512).subtract(ONE);
    private static final String LOG_BUFFER_WRITE_TYPE_VALUE_MESSAGE_STRING = "Writing type {} with value: {}";
    private static final String SERIALIZE_EXCEPTION_OUT_OF_BOUNDS_MESSAGE_STRING = "Value %s out of bounds for expected type %s";

    public SerializerBuffer() {
        this(4096, ByteOrder.LITTLE_ENDIAN);
    }

    public SerializerBuffer(ByteOrder byteOrder) {
        this(4096, byteOrder);
    }

    public SerializerBuffer(int initialCapacity, ByteOrder byteOrder) {
        this.buffer = ByteBuffer.allocate(initialCapacity);
        this.buffer.order(byteOrder);
        this.buffer.mark();
    }

    public void writeBool(boolean value) {
        LOGGER.debug(LOG_BUFFER_WRITE_TYPE_VALUE_MESSAGE_STRING, (Object)Boolean.class.getSimpleName(), (Object)value);
        byte boolByte = Boolean.TRUE.equals(value) ? (byte)1 : 0;
        this.put(boolByte);
    }

    public void writeU8(byte value) {
        LOGGER.debug(LOG_BUFFER_WRITE_TYPE_VALUE_MESSAGE_STRING, (Object)Byte.class.getSimpleName(), (Object)value);
        this.put(value);
    }

    public void writeU16(short value) {
        LOGGER.debug(LOG_BUFFER_WRITE_TYPE_VALUE_MESSAGE_STRING, (Object)Short.class.getSimpleName(), (Object)value);
        this.put(value);
    }

    public void writeByteArray(byte[] value) {
        LOGGER.debug(LOG_BUFFER_WRITE_TYPE_VALUE_MESSAGE_STRING, (Object)byte[].class.getSimpleName(), (Object)value);
        this.put(value);
    }

    public void writeF32(float value) {
        LOGGER.debug(LOG_BUFFER_WRITE_TYPE_VALUE_MESSAGE_STRING, (Object)Float.class.getSimpleName(), (Object)Float.valueOf(value));
        this.put(value);
    }

    public void writeF64(double value) {
        LOGGER.debug(LOG_BUFFER_WRITE_TYPE_VALUE_MESSAGE_STRING, (Object)Double.class.getSimpleName(), (Object)value);
        this.put(value);
    }

    public void writeI32(int value) {
        LOGGER.debug(LOG_BUFFER_WRITE_TYPE_VALUE_MESSAGE_STRING, (Object)Integer.class.getSimpleName(), (Object)value);
        this.put(value);
    }

    public void writeU32(Long value) {
        LOGGER.debug(LOG_BUFFER_WRITE_TYPE_VALUE_MESSAGE_STRING, (Object)Integer.class.getSimpleName(), (Object)value);
        this.put(value.intValue());
    }

    public void writeI64(long value) {
        LOGGER.debug(LOG_BUFFER_WRITE_TYPE_VALUE_MESSAGE_STRING, (Object)Long.class.getSimpleName(), (Object)value);
        this.put(value);
    }

    public void writeU64(BigInteger value) throws ValueSerializationException {
        Objects.requireNonNull(value);
        this.checkBoundsFor(value, 64);
        LOGGER.debug(LOG_BUFFER_WRITE_TYPE_VALUE_MESSAGE_STRING, (Object)BigInteger.class.getSimpleName(), (Object)value);
        this.put(value.longValue());
    }

    public void writeU128(BigInteger value) throws ValueSerializationException {
        this.writeBigInteger(value, 128);
    }

    public void writeU256(BigInteger value) throws ValueSerializationException {
        this.writeBigInteger(value, 256);
    }

    public void writeU512(BigInteger value) throws ValueSerializationException {
        this.writeBigInteger(value, 512);
    }

    protected void writeBigInteger(BigInteger value, int size) throws ValueSerializationException {
        Objects.requireNonNull(value);
        this.checkBoundsFor(value, size);
        LOGGER.debug(LOG_BUFFER_WRITE_TYPE_VALUE_MESSAGE_STRING, (Object)BigInteger.class.getSimpleName(), (Object)value);
        byte bigIntegerLength = (byte)Math.ceil((double)value.bitLength() / 8.0);
        byte[] byteArray = value.toByteArray();
        int skipped = 0;
        boolean skip = true;
        for (byte b : byteArray) {
            boolean signByte;
            boolean bl = signByte = b == 0;
            if (skip && signByte) {
                ++skipped;
                continue;
            }
            if (!skip) continue;
            skip = false;
        }
        byte[] bigIntegerBytes = Arrays.copyOfRange(byteArray, skipped, byteArray.length);
        if (this.buffer.order() == ByteOrder.LITTLE_ENDIAN) {
            ByteUtils.reverse(bigIntegerBytes);
        }
        this.put(bigIntegerLength);
        this.put(bigIntegerBytes);
    }

    public void writeString(String value) {
        LOGGER.debug(LOG_BUFFER_WRITE_TYPE_VALUE_MESSAGE_STRING, (Object)String.class.getSimpleName(), (Object)value);
        this.put(value.getBytes(StandardCharsets.UTF_8).length);
        this.put(value.getBytes(StandardCharsets.UTF_8));
    }

    private void checkBoundsFor(BigInteger value, int size) throws ValueSerializationException {
        BigInteger max;
        if (size == 64) {
            max = MAX_U64;
        } else if (size == 128) {
            max = MAX_U128;
        } else if (size == 256) {
            max = MAX_U256;
        } else if (size == 512) {
            max = MAX_U512;
        } else {
            throw new ValueSerializationException("Error checking numeric bounds", new NoSuchTypeException(String.format("%s is not a numeric size with check bounds for serializing", size)));
        }
        if (value.compareTo(max) > 0 || value.compareTo(ZERO) < 0) {
            throw new ValueSerializationException(String.format(SERIALIZE_EXCEPTION_OUT_OF_BOUNDS_MESSAGE_STRING, value, size));
        }
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public byte[] toByteArray() {
        return Arrays.copyOfRange(this.buffer.array(), this.buffer.arrayOffset(), this.buffer.arrayOffset() + this.buffer.position());
    }

    private void put(byte newByte) {
        if (this.buffer.position() + 1 >= this.buffer.capacity()) {
            this.increaseCapacity(1);
        }
        this.buffer.put(newByte);
    }

    private void put(short bytes) {
        if (this.buffer.position() + 2 >= this.buffer.capacity()) {
            this.increaseCapacity(2);
        }
        this.buffer.putShort(bytes);
    }

    private void put(byte[] newBytes) {
        if (this.buffer.position() + newBytes.length >= this.buffer.capacity()) {
            this.increaseCapacity(newBytes.length);
        }
        this.buffer.put(newBytes);
    }

    private void put(float bytes) {
        if (this.buffer.position() + 4 >= this.buffer.capacity()) {
            this.increaseCapacity(4);
        }
        this.buffer.putFloat(bytes);
    }

    private void put(double bytes) {
        if (this.buffer.position() + 8 >= this.buffer.capacity()) {
            this.increaseCapacity(8);
        }
        this.buffer.putDouble(bytes);
    }

    private void put(int bytes) {
        if (this.buffer.position() + 4 >= this.buffer.capacity()) {
            this.increaseCapacity(4);
        }
        this.buffer.putInt(bytes);
    }

    private void put(long bytes) {
        if (this.buffer.position() + 8 >= this.buffer.capacity()) {
            this.increaseCapacity(8);
        }
        this.buffer.putLong(bytes);
    }

    protected void increaseCapacity(int increaseByteCount) throws IllegalArgumentException {
        if (this.buffer == null) {
            throw new IllegalArgumentException("Buffer is null");
        }
        if (increaseByteCount < 0) {
            throw new IllegalArgumentException("Size cannot be less than 0");
        }
        int newCapacity = this.buffer.capacity() + increaseByteCount;
        ByteBuffer newBuffer = ByteBuffer.allocate(newCapacity);
        this.buffer.flip();
        newBuffer.order(this.buffer.order());
        newBuffer.put(this.buffer);
        this.buffer = newBuffer;
    }
}

