/*
 * Decompiled with CFR 0.152.
 */
package network.lightsail;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import network.lightsail.Language;
import network.lightsail.MnemonicKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\f\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007J\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lnetwork/lightsail/Mnemonic;", "", "language", "Lnetwork/lightsail/Language;", "wordlist", "", "", "<init>", "(Lnetwork/lightsail/Language;Ljava/util/List;)V", "getLanguage", "()Lnetwork/lightsail/Language;", "delimiter", "generate", "strength", "", "toEntropy", "", "words", "toMnemonic", "entropy", "check", "", "mnemonic", "expandWord", "prefix", "expand", "Companion", "mnemonic4j"})
@SourceDebugExtension(value={"SMAP\nMnemonic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Mnemonic.kt\nnetwork/lightsail/Mnemonic\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,357:1\n1#2:358\n1#2:363\n54#3,4:359\n10018#4:364\n10442#4,2:365\n10444#4,3:371\n1557#5:367\n1628#5,3:368\n1557#5:374\n1628#5,3:375\n774#5:378\n865#5,2:379\n*S KotlinDebug\n*F\n+ 1 Mnemonic.kt\nnetwork/lightsail/Mnemonic\n*L\n33#1:363\n33#1:359,4\n220#1:364\n220#1:365,2\n220#1:371,3\n221#1:367\n221#1:368,3\n269#1:374\n269#1:375,3\n292#1:378\n292#1:379,2\n*E\n"})
public final class Mnemonic {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Language language;
    @NotNull
    private final List<String> wordlist;
    @NotNull
    private final String delimiter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Mnemonic(@NotNull Language language, @Nullable List<String> wordlist) {
        List wordlistFile;
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        this.language = language;
        List list = wordlist;
        if (list == null) {
            void $this$useLines$iv;
            Mnemonic $this$_init__u24lambda_u242 = this;
            boolean bl = false;
            String resourceName = "wordlist/" + $this$_init__u24lambda_u242.language.getCode() + ".txt";
            InputStream inputStream = Mnemonic.class.getClassLoader().getResourceAsStream(resourceName);
            if (inputStream == null) {
                boolean $i$a$-checkNotNull-Mnemonic$wordlistFile$1$22 = false;
                String $i$a$-checkNotNull-Mnemonic$wordlistFile$1$22 = "Word list file not found for language: " + $this$_init__u24lambda_u242.language;
                throw new IllegalStateException($i$a$-checkNotNull-Mnemonic$wordlistFile$1$22.toString());
            }
            Closeable $i$a$-checkNotNull-Mnemonic$wordlistFile$1$22 = inputStream;
            Charset charset = Charsets.UTF_8;
            Closeable closeable = new InputStreamReader((InputStream)$i$a$-checkNotNull-Mnemonic$wordlistFile$1$22, charset);
            int n = 8192;
            $i$a$-checkNotNull-Mnemonic$wordlistFile$1$22 = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
            boolean $i$f$useLines = false;
            closeable = $this$useLines$iv;
            n = 8192;
            closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
            Throwable throwable = null;
            try {
                BufferedReader it$iv = (BufferedReader)closeable;
                boolean bl2 = false;
                Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl3 = false;
                List list2 = SequencesKt.toList((Sequence)it);
                list = list2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        if (!((wordlistFile = list).size() == 2048)) {
            boolean bl = false;
            String string = "Wordlist must contain 2048 words.";
            throw new IllegalArgumentException(string.toString());
        }
        this.wordlist = wordlistFile;
        this.delimiter = this.language == Language.JAPANESE ? "\u3000" : " ";
    }

    public /* synthetic */ Mnemonic(Language language, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            language = Language.ENGLISH;
        }
        if ((n & 2) != 0) {
            list = null;
        }
        this(language, list);
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    @JvmOverloads
    @NotNull
    public final String generate(int strength) {
        Object[] objectArray = new Integer[]{128, 160, 192, 224, 256};
        if (!CollectionsKt.listOf((Object[])objectArray).contains(strength)) {
            boolean bl = false;
            String string = "Invalid strength value. Allowed values are [128, 160, 192, 224, 256].";
            throw new IllegalArgumentException(string.toString());
        }
        byte[] entropy = new byte[strength / 8];
        new SecureRandom().nextBytes(entropy);
        return this.toMnemonic(entropy);
    }

    public static /* synthetic */ String generate$default(Mnemonic mnemonic, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 128;
        }
        return mnemonic.generate(n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] toEntropy(@NotNull List<String> words) {
        void $this$flatMapTo$iv$iv;
        int ndx;
        Intrinsics.checkNotNullParameter(words, (String)"words");
        Object[] objectArray = new Integer[]{12, 15, 18, 21, 24};
        if (!CollectionsKt.listOf((Object[])objectArray).contains(words.size())) {
            boolean $i$a$-require-Mnemonic$toEntropy$32 = false;
            String $i$a$-require-Mnemonic$toEntropy$32 = "Number of words must be one of the following: [12, 15, 18, 21, 24], but it is not (" + words.size() + ").";
            throw new IllegalArgumentException($i$a$-require-Mnemonic$toEntropy$32.toString());
        }
        int concatLenBits = words.size() * 11;
        boolean[] concatBits = new boolean[concatLenBits];
        Iterator iterator = ((Iterable)words).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int wordIndex = n++;
            String word = (String)iterator.next();
            ndx = this.wordlist.indexOf(Mnemonic.Companion.normalizeString(word));
            if (!(ndx >= 0)) {
                boolean $i$a$-require-Mnemonic$toEntropy$42 = false;
                String $i$a$-require-Mnemonic$toEntropy$42 = "Unable to find \"" + word + "\" in word list.";
                throw new IllegalArgumentException($i$a$-require-Mnemonic$toEntropy$42.toString());
            }
            for (int ii = 0; ii < 11; ++ii) {
                concatBits[wordIndex * 11 + ii] = (ndx & 1 << 10 - ii) != 0;
            }
        }
        int checksumLengthBits = concatLenBits / 33;
        int entropyLengthBits = concatLenBits - checksumLengthBits;
        byte[] entropy = new byte[entropyLengthBits / 8];
        ndx = entropy.length;
        for (int ii = 0; ii < ndx; ++ii) {
            for (int jj = 0; jj < 8; ++jj) {
                if (!concatBits[ii * 8 + jj]) continue;
                entropy[ii] = (byte)(entropy[ii] | 1 << 7 - jj);
            }
        }
        byte[] hashBytes = MessageDigest.getInstance("SHA-256").digest(entropy);
        Intrinsics.checkNotNull((Object)hashBytes);
        byte[] $this$flatMap$iv = hashBytes;
        boolean $i$f$flatMap = false;
        byte[] byArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n2 = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n2; ++i) {
            void $this$mapTo$iv$iv;
            void element$iv$iv;
            void byteVal = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl = false;
            Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)8);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void bit;
                int item$iv$iv;
                int n3 = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add((byteVal & 1 << 7 - bit) != 0);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List hashBits = (List)destination$iv$iv;
        for (int i = 0; i < checksumLengthBits; ++i) {
            int i2 = i;
            boolean bl = false;
            if (concatBits[entropyLengthBits + i2] == (Boolean)hashBits.get(i2)) continue;
            boolean bl3 = false;
            String string = "Failed checksum.";
            throw new IllegalArgumentException(string.toString());
        }
        return entropy;
    }

    @NotNull
    public final String toMnemonic(@NotNull byte[] entropy) {
        Intrinsics.checkNotNullParameter((Object)entropy, (String)"entropy");
        Object[] objectArray = new Integer[]{16, 20, 24, 28, 32};
        if (!CollectionsKt.listOf((Object[])objectArray).contains(entropy.length)) {
            boolean $i$a$-require-Mnemonic$toMnemonic$22 = false;
            String $i$a$-require-Mnemonic$toMnemonic$22 = "Data length should be one of the following: [16, 20, 24, 28, 32], but it is not " + entropy.length + ".";
            throw new IllegalArgumentException($i$a$-require-Mnemonic$toMnemonic$22.toString());
        }
        byte[] hash = MessageDigest.getInstance("SHA-256").digest(entropy);
        String string = MnemonicKt.access$toBitString(entropy);
        Intrinsics.checkNotNull((Object)hash);
        String string2 = MnemonicKt.access$toBitString(hash).substring(0, entropy.length * 8 / 32);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String b = string + string2;
        List result = new ArrayList();
        int n = b.length() / 11;
        for (int i = 0; i < n; ++i) {
            String string3 = b.substring(i * 11, (i + 1) * 11);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            int idx = Integer.parseInt(string3, CharsKt.checkRadix((int)2));
            result.add(this.wordlist.get(idx));
        }
        return CollectionsKt.joinToString$default((Iterable)result, (CharSequence)this.delimiter, null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean check(@NotNull String mnemonic) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)mnemonic, (String)"mnemonic");
        Object[] objectArray = new String[]{" "};
        List mnemonicList = StringsKt.split$default((CharSequence)Mnemonic.Companion.normalizeString(mnemonic), (String[])objectArray, (boolean)false, (int)0, (int)6, null);
        objectArray = new Integer[]{12, 15, 18, 21, 24};
        if (!CollectionsKt.listOf((Object[])objectArray).contains(mnemonicList.size())) {
            return false;
        }
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = mnemonicList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string2 = Integer.toString(this.wordlist.indexOf(it), CharsKt.checkRadix((int)2));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                collection.add(StringsKt.padStart((String)string2, (int)11, (char)'0'));
            }
            List idx = (List)destination$iv$iv;
            String b = CollectionsKt.joinToString$default((Iterable)idx, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            int l = b.length();
            String string = b.substring(0, l / 33 * 32);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String d = string;
            String string3 = b.substring(l / 33 * 32);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String h = string3;
            byte[] nd = MnemonicKt.access$toBytes(new BigInteger(d, CharsKt.checkRadix((int)2)), l / 33 * 4);
            byte[] byArray = MessageDigest.getInstance("SHA-256").digest(nd);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
            String string4 = MnemonicKt.access$toBitString(byArray);
            int n = 0;
            int n2 = l / 33;
            String string5 = string4.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            String nh = string5;
            bl = Intrinsics.areEqual((Object)h, (Object)nh);
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String expandWord(@NotNull String prefix) {
        String string;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (this.wordlist.contains(prefix)) {
            string = prefix;
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.wordlist;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)prefix, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List matches = (List)destination$iv$iv;
            string = matches.size() == 1 ? (String)matches.get(0) : prefix;
        }
        return string;
    }

    @NotNull
    public final String expand(@NotNull String mnemonic) {
        Intrinsics.checkNotNullParameter((Object)mnemonic, (String)"mnemonic");
        String[] stringArray = new String[]{" "};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)mnemonic, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)" ", null, null, (int)0, null, arg_0 -> Mnemonic.expand$lambda$14(this, arg_0), (int)30, null);
    }

    @JvmOverloads
    @NotNull
    public final String generate() {
        return Mnemonic.generate$default(this, 0, 1, null);
    }

    private static final CharSequence expand$lambda$14(Mnemonic this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.expandWord(it);
    }

    public Mnemonic() {
        this(null, null, 3, null);
    }

    @JvmStatic
    @NotNull
    public static final Language detectLanguage(@NotNull String mnemonic) {
        return Companion.detectLanguage(mnemonic);
    }

    @JvmStatic
    @NotNull
    public static final byte[] toSeed(@NotNull String mnemonic, @NotNull String passphrase) {
        return Companion.toSeed(mnemonic, passphrase);
    }

    @JvmStatic
    @NotNull
    public static final String toHdMasterKey(@NotNull byte[] seed, boolean testnet) {
        return Companion.toHdMasterKey(seed, testnet);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007H\u0007J\u001a\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\u00a8\u0006\u0011"}, d2={"Lnetwork/lightsail/Mnemonic$Companion;", "", "<init>", "()V", "detectLanguage", "Lnetwork/lightsail/Language;", "mnemonic", "", "toSeed", "", "passphrase", "toHdMasterKey", "seed", "testnet", "", "normalizeString", "txt", "mnemonic4j"})
    @SourceDebugExtension(value={"SMAP\nMnemonic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Mnemonic.kt\nnetwork/lightsail/Mnemonic$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,357:1\n739#2,9:358\n37#3,2:367\n1#4:369\n*S KotlinDebug\n*F\n+ 1 Mnemonic.kt\nnetwork/lightsail/Mnemonic$Companion\n*L\n60#1:358,9\n60#1:367,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Language detectLanguage(@NotNull String mnemonic) {
            void $this$toTypedArray$iv;
            List list;
            Collection $this$dropLastWhile$iv;
            Intrinsics.checkNotNullParameter((Object)mnemonic, (String)"mnemonic");
            String normalizedMnemonic = this.normalizeString(mnemonic);
            Set possible = new HashSet();
            for (Language language : Language.Companion.getAllLanguages()) {
                possible.add(new Mnemonic(language, null, 2, null));
            }
            Iterator iterator = normalizedMnemonic;
            Regex regex = new Regex(" ");
            int n = 0;
            iterator = regex.split((CharSequence)((Object)iterator), n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            Collection collection = CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray, stringArray.length));
            Set words = new HashSet(collection);
            for (String word : words) {
                possible.removeIf(arg_0 -> Companion.detectLanguage$lambda$4(arg_0 -> Companion.detectLanguage$lambda$3(word, arg_0), arg_0));
                if (!((Collection)possible).isEmpty()) continue;
                boolean $i$a$-require-Mnemonic$Companion$detectLanguage$332 = false;
                String $i$a$-require-Mnemonic$Companion$detectLanguage$332 = "Language unrecognized for word: " + word;
                throw new IllegalArgumentException($i$a$-require-Mnemonic$Companion$detectLanguage$332.toString());
            }
            if (possible.size() == 1) {
                return ((Mnemonic)possible.iterator().next()).getLanguage();
            }
            Set set = new HashSet();
            for (String word : words) {
                Set exact = possible.stream().filter(arg_0 -> Companion.detectLanguage$lambda$7(arg_0 -> Companion.detectLanguage$lambda$6(word, arg_0), arg_0)).collect(Collectors.toSet());
                if (exact.size() != 1) continue;
                Intrinsics.checkNotNull(exact);
                set.addAll(exact);
            }
            if (set.size() == 1) {
                return ((Mnemonic)set.iterator().next()).getLanguage();
            }
            throw new IllegalArgumentException("Language ambiguous between " + possible.stream().map(arg_0 -> Companion.detectLanguage$lambda$9(Companion::detectLanguage$lambda$8, arg_0)).collect(Collectors.joining(", ")));
        }

        @JvmStatic
        @NotNull
        public final byte[] toSeed(@NotNull String mnemonic, @NotNull String passphrase) {
            Intrinsics.checkNotNullParameter((Object)mnemonic, (String)"mnemonic");
            Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
            String normalizedMnemonic = this.normalizeString(mnemonic);
            String normalizedPassphrase = this.normalizeString("mnemonic" + passphrase);
            String string = normalizedMnemonic;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] mnemonicBytes = byArray;
            String string2 = normalizedPassphrase;
            Charset charset2 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
            byte[] byArray2 = string2.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            byte[] passphraseBytes = byArray2;
            char[] cArray = new String(mnemonicBytes, Charsets.UTF_8).toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            PBEKeySpec spec = new PBEKeySpec(cArray, passphraseBytes, 2048, 512);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            byte[] byArray3 = skf.generateSecret(spec).getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getEncoded(...)");
            byte[] byArray4 = byArray3;
            int n = 0;
            int n2 = 64;
            return ArraysKt.copyOfRange((byte[])byArray4, (int)n, (int)n2);
        }

        public static /* synthetic */ byte[] toSeed$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "";
            }
            return companion.toSeed(string, string2);
        }

        @JvmStatic
        @NotNull
        public final String toHdMasterKey(@NotNull byte[] seed, boolean testnet) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
            if (!(seed.length == 64)) {
                boolean $i$a$-require-Mnemonic$Companion$toHdMasterKey$22 = false;
                String $i$a$-require-Mnemonic$Companion$toHdMasterKey$22 = "Provided seed should have length of 64";
                throw new IllegalArgumentException($i$a$-require-Mnemonic$Companion$toHdMasterKey$22.toString());
            }
            String $i$a$-require-Mnemonic$Companion$toHdMasterKey$22 = "Bitcoin seed";
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray2 = $i$a$-require-Mnemonic$Companion$toHdMasterKey$22.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            byte[] hmacKey = byArray2;
            Mac mac = Mac.getInstance("HmacSHA512");
            mac.init(new SecretKeySpec(hmacKey, "HmacSHA512"));
            byte[] seedHmac = mac.doFinal(seed);
            if (testnet) {
                var7_8 = new byte[]{4, 53, -125, -108};
                byArray = var7_8;
            } else {
                var7_8 = new byte[]{4, -120, -83, -28};
                byArray = var7_8;
            }
            byte[] prefix = byArray;
            byte[] byArray3 = ArraysKt.plus((byte[])prefix, (byte[])new byte[9]);
            Intrinsics.checkNotNull((Object)seedHmac);
            byte[] byArray4 = seedHmac;
            int n = 32;
            int n2 = 64;
            byte[] byArray5 = ArraysKt.plus((byte[])byArray3, (byte[])ArraysKt.copyOfRange((byte[])byArray4, (int)n, (int)n2));
            byArray4 = new byte[]{0};
            byte[] byArray6 = ArraysKt.plus((byte[])byArray5, (byte[])byArray4);
            byArray4 = seedHmac;
            n = 0;
            n2 = 32;
            byte[] xprv = ArraysKt.plus((byte[])byArray6, (byte[])ArraysKt.copyOfRange((byte[])byArray4, (int)n, (int)n2));
            byte[] hashedXprv = MessageDigest.getInstance("SHA-256").digest(xprv);
            byte[] doubleHashedXprv = MessageDigest.getInstance("SHA-256").digest(hashedXprv);
            Intrinsics.checkNotNull((Object)doubleHashedXprv);
            byte[] byArray7 = doubleHashedXprv;
            int n3 = 0;
            int n4 = 4;
            byte[] xprvWithChecksum = ArraysKt.plus((byte[])xprv, (byte[])ArraysKt.copyOfRange((byte[])byArray7, (int)n3, (int)n4));
            return MnemonicKt.access$base58Encode(xprvWithChecksum);
        }

        public static /* synthetic */ String toHdMasterKey$default(Companion companion, byte[] byArray, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.toHdMasterKey(byArray, bl);
        }

        private final String normalizeString(Object txt) {
            String string;
            Object object = txt;
            if (object instanceof byte[]) {
                string = new String((byte[])txt, Charsets.UTF_8);
            } else if (object instanceof String) {
                string = (String)txt;
            } else {
                throw new IllegalArgumentException("String value expected");
            }
            String utxt = string;
            String string2 = Normalizer.normalize(utxt, Normalizer.Form.NFKD);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"normalize(...)");
            return string2;
        }

        private static final boolean detectLanguage$lambda$3$lambda$1(String $word, String c) {
            Intrinsics.checkNotNullParameter((Object)$word, (String)"$word");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            return StringsKt.startsWith$default((String)c, (String)$word, (boolean)false, (int)2, null);
        }

        private static final boolean detectLanguage$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean detectLanguage$lambda$3(String $word, Mnemonic p) {
            Intrinsics.checkNotNullParameter((Object)$word, (String)"$word");
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return p.wordlist.stream().noneMatch(arg_0 -> Companion.detectLanguage$lambda$3$lambda$2(arg_0 -> Companion.detectLanguage$lambda$3$lambda$1($word, arg_0), arg_0));
        }

        private static final boolean detectLanguage$lambda$4(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean detectLanguage$lambda$6(String $word, Mnemonic p) {
            Intrinsics.checkNotNullParameter((Object)$word, (String)"$word");
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return p.wordlist.contains($word);
        }

        private static final boolean detectLanguage$lambda$7(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final String detectLanguage$lambda$8(Mnemonic p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return p.getLanguage().getCode();
        }

        private static final String detectLanguage$lambda$9(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

