/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdkandroidspi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.stellar.sdk.Base64;

class AndroidBase64
implements Base64 {
    private static final Class<?> BASE64_CLASS_ANDROID = AndroidBase64.getBase64ClassAndroid();

    AndroidBase64() {
    }

    private static Class<?> getBase64ClassAndroid() {
        try {
            return Class.forName("android.util.Base64");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String encodeToString(byte[] data) {
        try {
            Method encodeToString = BASE64_CLASS_ANDROID.getDeclaredMethod("encodeToString", byte[].class, Integer.TYPE);
            return (String)encodeToString.invoke(null, data, 2);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] encode(byte[] data) {
        try {
            Method encode = BASE64_CLASS_ANDROID.getDeclaredMethod("encode", byte[].class, Integer.TYPE);
            return (byte[])encode.invoke(null, data, 2);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] decode(String data) {
        try {
            Method decode = BASE64_CLASS_ANDROID.getDeclaredMethod("decode", String.class, Integer.TYPE);
            return (byte[])decode.invoke(null, data, 2);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

