/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdkandroidspi;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

class ApacheCodec {
    ApacheCodec() {
    }

    static class StringUtils {
        StringUtils() {
        }

        private static byte[] getBytes(String string, Charset charset) {
            return string == null ? null : string.getBytes(charset);
        }

        public static byte[] getBytesUtf8(String string) {
            return StringUtils.getBytes(string, StandardCharsets.UTF_8);
        }

        private static String newString(byte[] bytes, Charset charset) {
            return bytes == null ? null : new String(bytes, charset);
        }

        public static String newStringUsAscii(byte[] bytes) {
            return StringUtils.newString(bytes, StandardCharsets.US_ASCII);
        }

        public static String newStringUtf8(byte[] bytes) {
            return StringUtils.newString(bytes, StandardCharsets.UTF_8);
        }
    }

    static class EncoderException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public EncoderException() {
        }

        public EncoderException(String message) {
            super(message);
        }

        public EncoderException(String message, Throwable cause) {
            super(message, cause);
        }

        public EncoderException(Throwable cause) {
            super(cause);
        }
    }

    static class DecoderException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DecoderException() {
        }

        public DecoderException(String message) {
            super(message);
        }

        public DecoderException(String message, Throwable cause) {
            super(message, cause);
        }

        public DecoderException(Throwable cause) {
            super(cause);
        }
    }

    static class Base32OutputStream
    extends BaseNCodecOutputStream {
        public Base32OutputStream(OutputStream outputStream) {
            this(outputStream, true);
        }

        public Base32OutputStream(OutputStream outputStream, boolean doEncode) {
            super(outputStream, new Base32(false), doEncode);
        }

        public Base32OutputStream(OutputStream outputStream, boolean doEncode, int lineLength, byte[] lineSeparator) {
            super(outputStream, new Base32(lineLength, lineSeparator), doEncode);
        }

        public Base32OutputStream(OutputStream outputStream, boolean doEncode, int lineLength, byte[] lineSeparator, CodecPolicy decodingPolicy) {
            super(outputStream, new Base32(lineLength, lineSeparator, false, 61, decodingPolicy), doEncode);
        }
    }

    static class BaseNCodecOutputStream
    extends FilterOutputStream {
        private final boolean doEncode;
        private final BaseNCodec baseNCodec;
        private final byte[] singleByte = new byte[1];
        private final BaseNCodec.Context context = new BaseNCodec.Context();

        public BaseNCodecOutputStream(OutputStream outputStream, BaseNCodec basedCodec, boolean doEncode) {
            super(outputStream);
            this.baseNCodec = basedCodec;
            this.doEncode = doEncode;
        }

        @Override
        public void close() throws IOException {
            this.eof();
            this.flush();
            this.out.close();
        }

        public void eof() {
            if (this.doEncode) {
                this.baseNCodec.encode(this.singleByte, 0, -1, this.context);
            } else {
                this.baseNCodec.decode(this.singleByte, 0, -1, this.context);
            }
        }

        @Override
        public void flush() throws IOException {
            this.flush(true);
        }

        private void flush(boolean propagate) throws IOException {
            byte[] buf;
            int c;
            int avail = this.baseNCodec.available(this.context);
            if (avail > 0 && (c = this.baseNCodec.readResults(buf = new byte[avail], 0, avail, this.context)) > 0) {
                this.out.write(buf, 0, c);
            }
            if (propagate) {
                this.out.flush();
            }
        }

        public boolean isStrictDecoding() {
            return this.baseNCodec.isStrictDecoding();
        }

        @Override
        public void write(byte[] array, int offset, int len) throws IOException {
            Objects.requireNonNull(array, "array");
            if (offset < 0 || len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (offset > array.length || offset + len > array.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len > 0) {
                if (this.doEncode) {
                    this.baseNCodec.encode(array, offset, len, this.context);
                } else {
                    this.baseNCodec.decode(array, offset, len, this.context);
                }
                this.flush(false);
            }
        }

        @Override
        public void write(int i) throws IOException {
            this.singleByte[0] = (byte)i;
            this.write(this.singleByte, 0, 1);
        }
    }

    static abstract class BaseNCodec {
        public static final int MIME_CHUNK_SIZE = 76;
        public static final int PEM_CHUNK_SIZE = 64;
        protected static final int MASK_8BITS = 255;
        protected static final byte PAD_DEFAULT = 61;
        protected static final CodecPolicy DECODING_POLICY_DEFAULT = CodecPolicy.LENIENT;
        static final int EOF = -1;
        static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
        private static final int DEFAULT_BUFFER_RESIZE_FACTOR = 2;
        private static final int DEFAULT_BUFFER_SIZE = 8192;
        private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
        @Deprecated
        protected final byte PAD = (byte)61;
        protected final byte pad;
        protected final int lineLength;
        private final int unencodedBlockSize;
        private final int encodedBlockSize;
        private final int chunkSeparatorLength;
        private final CodecPolicy decodingPolicy;

        protected BaseNCodec(int unencodedBlockSize, int encodedBlockSize, int lineLength, int chunkSeparatorLength) {
            this(unencodedBlockSize, encodedBlockSize, lineLength, chunkSeparatorLength, 61);
        }

        protected BaseNCodec(int unencodedBlockSize, int encodedBlockSize, int lineLength, int chunkSeparatorLength, byte pad) {
            this(unencodedBlockSize, encodedBlockSize, lineLength, chunkSeparatorLength, pad, DECODING_POLICY_DEFAULT);
        }

        protected BaseNCodec(int unencodedBlockSize, int encodedBlockSize, int lineLength, int chunkSeparatorLength, byte pad, CodecPolicy decodingPolicy) {
            this.unencodedBlockSize = unencodedBlockSize;
            this.encodedBlockSize = encodedBlockSize;
            boolean useChunking = lineLength > 0 && chunkSeparatorLength > 0;
            this.lineLength = useChunking ? lineLength / encodedBlockSize * encodedBlockSize : 0;
            this.chunkSeparatorLength = chunkSeparatorLength;
            this.pad = pad;
            this.decodingPolicy = Objects.requireNonNull(decodingPolicy, "codecPolicy");
        }

        private static int createPositiveCapacity(int minCapacity) {
            if (minCapacity < 0) {
                throw new OutOfMemoryError("Unable to allocate array size: " + ((long)minCapacity & 0xFFFFFFFFL));
            }
            return Math.max(minCapacity, 0x7FFFFFF7);
        }

        public static byte[] getChunkSeparator() {
            return (byte[])CHUNK_SEPARATOR.clone();
        }

        @Deprecated
        protected static boolean isWhiteSpace(byte byteToCheck) {
            return Character.isWhitespace(byteToCheck);
        }

        private static byte[] resizeBuffer(Context context, int minCapacity) {
            int oldCapacity = context.buffer.length;
            int newCapacity = oldCapacity * 2;
            if (Integer.compareUnsigned(newCapacity, minCapacity) < 0) {
                newCapacity = minCapacity;
            }
            if (Integer.compareUnsigned(newCapacity, 0x7FFFFFF7) > 0) {
                newCapacity = BaseNCodec.createPositiveCapacity(minCapacity);
            }
            byte[] b = Arrays.copyOf(context.buffer, newCapacity);
            context.buffer = b;
            return b;
        }

        int available(Context context) {
            return this.hasData(context) ? context.pos - context.readPos : 0;
        }

        protected boolean containsAlphabetOrPad(byte[] arrayOctet) {
            if (arrayOctet == null) {
                return false;
            }
            for (byte element : arrayOctet) {
                if (this.pad != element && !this.isInAlphabet(element)) continue;
                return true;
            }
            return false;
        }

        public byte[] decode(byte[] pArray) {
            if (BinaryCodec.isEmpty(pArray)) {
                return pArray;
            }
            Context context = new Context();
            this.decode(pArray, 0, pArray.length, context);
            this.decode(pArray, 0, -1, context);
            byte[] result = new byte[context.pos];
            this.readResults(result, 0, result.length, context);
            return result;
        }

        abstract void decode(byte[] var1, int var2, int var3, Context var4);

        public Object decode(Object obj) throws DecoderException {
            if (obj instanceof byte[]) {
                return this.decode((byte[])obj);
            }
            if (obj instanceof String) {
                return this.decode((String)obj);
            }
            throw new DecoderException("Parameter supplied to Base-N decode is not a byte[] or a String");
        }

        public byte[] decode(String pArray) {
            return this.decode(StringUtils.getBytesUtf8(pArray));
        }

        public byte[] encode(byte[] pArray) {
            if (BinaryCodec.isEmpty(pArray)) {
                return pArray;
            }
            return this.encode(pArray, 0, pArray.length);
        }

        public byte[] encode(byte[] pArray, int offset, int length) {
            if (BinaryCodec.isEmpty(pArray)) {
                return pArray;
            }
            Context context = new Context();
            this.encode(pArray, offset, length, context);
            this.encode(pArray, offset, -1, context);
            byte[] buf = new byte[context.pos - context.readPos];
            this.readResults(buf, 0, buf.length, context);
            return buf;
        }

        abstract void encode(byte[] var1, int var2, int var3, Context var4);

        public Object encode(Object obj) throws EncoderException {
            if (!(obj instanceof byte[])) {
                throw new EncoderException("Parameter supplied to Base-N encode is not a byte[]");
            }
            return this.encode((byte[])obj);
        }

        public String encodeAsString(byte[] pArray) {
            return StringUtils.newStringUtf8(this.encode(pArray));
        }

        public String encodeToString(byte[] pArray) {
            return StringUtils.newStringUtf8(this.encode(pArray));
        }

        protected byte[] ensureBufferSize(int size, Context context) {
            if (context.buffer == null) {
                context.buffer = new byte[Math.max(size, this.getDefaultBufferSize())];
                context.pos = 0;
                context.readPos = 0;
            } else if (context.pos + size - context.buffer.length > 0) {
                return BaseNCodec.resizeBuffer(context, context.pos + size);
            }
            return context.buffer;
        }

        public CodecPolicy getCodecPolicy() {
            return this.decodingPolicy;
        }

        protected int getDefaultBufferSize() {
            return 8192;
        }

        public long getEncodedLength(byte[] pArray) {
            long len = (long)((pArray.length + this.unencodedBlockSize - 1) / this.unencodedBlockSize) * (long)this.encodedBlockSize;
            if (this.lineLength > 0) {
                len += (len + (long)this.lineLength - 1L) / (long)this.lineLength * (long)this.chunkSeparatorLength;
            }
            return len;
        }

        boolean hasData(Context context) {
            return context.pos > context.readPos;
        }

        protected abstract boolean isInAlphabet(byte var1);

        public boolean isInAlphabet(byte[] arrayOctet, boolean allowWSPad) {
            for (byte octet : arrayOctet) {
                if (this.isInAlphabet(octet) || allowWSPad && (octet == this.pad || Character.isWhitespace(octet))) continue;
                return false;
            }
            return true;
        }

        public boolean isInAlphabet(String basen) {
            return this.isInAlphabet(StringUtils.getBytesUtf8(basen), true);
        }

        public boolean isStrictDecoding() {
            return this.decodingPolicy == CodecPolicy.STRICT;
        }

        int readResults(byte[] b, int bPos, int bAvail, Context context) {
            if (this.hasData(context)) {
                int len = Math.min(this.available(context), bAvail);
                System.arraycopy(context.buffer, context.readPos, b, bPos, len);
                context.readPos += len;
                if (!this.hasData(context)) {
                    context.readPos = 0;
                    context.pos = 0;
                }
                return len;
            }
            return context.eof ? -1 : 0;
        }

        static class Context {
            int ibitWorkArea;
            long lbitWorkArea;
            byte[] buffer;
            int pos;
            int readPos;
            boolean eof;
            int currentLinePos;
            int modulus;

            Context() {
            }

            public String toString() {
                return String.format("%s[buffer=%s, currentLinePos=%s, eof=%s, ibitWorkArea=%s, lbitWorkArea=%s, modulus=%s, pos=%s, readPos=%s]", this.getClass().getSimpleName(), Arrays.toString(this.buffer), this.currentLinePos, this.eof, this.ibitWorkArea, this.lbitWorkArea, this.modulus, this.pos, this.readPos);
            }
        }
    }

    static class BinaryCodec {
        private static final char[] EMPTY_CHAR_ARRAY = new char[0];
        private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
        private static final int BIT_0 = 1;
        private static final int BIT_1 = 2;
        private static final int BIT_2 = 4;
        private static final int BIT_3 = 8;
        private static final int BIT_4 = 16;
        private static final int BIT_5 = 32;
        private static final int BIT_6 = 64;
        private static final int BIT_7 = 128;
        private static final int[] BITS = new int[]{1, 2, 4, 8, 16, 32, 64, 128};

        BinaryCodec() {
        }

        public static byte[] fromAscii(byte[] ascii) {
            if (BinaryCodec.isEmpty(ascii)) {
                return EMPTY_BYTE_ARRAY;
            }
            int asciiLength = ascii.length;
            byte[] raw = new byte[asciiLength >> 3];
            int ii = 0;
            int jj = asciiLength - 1;
            while (ii < raw.length) {
                for (int bits = 0; bits < BITS.length; ++bits) {
                    if (ascii[jj - bits] != 49) continue;
                    int n = ii;
                    raw[n] = (byte)(raw[n] | BITS[bits]);
                }
                ++ii;
                jj -= 8;
            }
            return raw;
        }

        public static byte[] fromAscii(char[] ascii) {
            if (ascii == null || ascii.length == 0) {
                return EMPTY_BYTE_ARRAY;
            }
            int asciiLength = ascii.length;
            byte[] raw = new byte[asciiLength >> 3];
            int ii = 0;
            int jj = asciiLength - 1;
            while (ii < raw.length) {
                for (int bits = 0; bits < BITS.length; ++bits) {
                    if (ascii[jj - bits] != '1') continue;
                    int n = ii;
                    raw[n] = (byte)(raw[n] | BITS[bits]);
                }
                ++ii;
                jj -= 8;
            }
            return raw;
        }

        static boolean isEmpty(byte[] array) {
            return array == null || array.length == 0;
        }

        public static byte[] toAsciiBytes(byte[] raw) {
            if (BinaryCodec.isEmpty(raw)) {
                return EMPTY_BYTE_ARRAY;
            }
            int rawLength = raw.length;
            byte[] l_ascii = new byte[rawLength << 3];
            int ii = 0;
            int jj = l_ascii.length - 1;
            while (ii < rawLength) {
                for (int bits = 0; bits < BITS.length; ++bits) {
                    l_ascii[jj - bits] = (raw[ii] & BITS[bits]) == 0 ? 48 : 49;
                }
                ++ii;
                jj -= 8;
            }
            return l_ascii;
        }

        public static char[] toAsciiChars(byte[] raw) {
            if (BinaryCodec.isEmpty(raw)) {
                return EMPTY_CHAR_ARRAY;
            }
            int rawLength = raw.length;
            char[] l_ascii = new char[rawLength << 3];
            int ii = 0;
            int jj = l_ascii.length - 1;
            while (ii < rawLength) {
                for (int bits = 0; bits < BITS.length; ++bits) {
                    l_ascii[jj - bits] = (raw[ii] & BITS[bits]) == 0 ? 48 : 49;
                }
                ++ii;
                jj -= 8;
            }
            return l_ascii;
        }

        public static String toAsciiString(byte[] raw) {
            return new String(BinaryCodec.toAsciiChars(raw));
        }

        public byte[] decode(byte[] ascii) {
            return BinaryCodec.fromAscii(ascii);
        }

        public Object decode(Object ascii) throws DecoderException {
            if (ascii == null) {
                return EMPTY_BYTE_ARRAY;
            }
            if (ascii instanceof byte[]) {
                return BinaryCodec.fromAscii((byte[])ascii);
            }
            if (ascii instanceof char[]) {
                return BinaryCodec.fromAscii((char[])ascii);
            }
            if (ascii instanceof String) {
                return BinaryCodec.fromAscii(((String)ascii).toCharArray());
            }
            throw new DecoderException("argument not a byte array");
        }

        public byte[] encode(byte[] raw) {
            return BinaryCodec.toAsciiBytes(raw);
        }

        public Object encode(Object raw) throws EncoderException {
            if (!(raw instanceof byte[])) {
                throw new EncoderException("argument not a byte array");
            }
            return BinaryCodec.toAsciiChars((byte[])raw);
        }

        public byte[] toByteArray(String ascii) {
            if (ascii == null) {
                return EMPTY_BYTE_ARRAY;
            }
            return BinaryCodec.fromAscii(ascii.toCharArray());
        }
    }

    static class Base32
    extends BaseNCodec {
        private static final int BITS_PER_ENCODED_BYTE = 5;
        private static final int BYTES_PER_ENCODED_BLOCK = 8;
        private static final int BYTES_PER_UNENCODED_BLOCK = 5;
        private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25};
        private static final byte[] ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 50, 51, 52, 53, 54, 55};
        private static final byte[] HEX_DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
        private static final byte[] HEX_ENCODE_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86};
        private static final int MASK_5BITS = 31;
        private static final long MASK_4BITS = 15L;
        private static final long MASK_3BITS = 7L;
        private static final long MASK_2BITS = 3L;
        private static final long MASK_1BITS = 1L;
        private final int decodeSize;
        private final byte[] decodeTable;
        private final int encodeSize;
        private final byte[] encodeTable;
        private final byte[] lineSeparator;

        public Base32() {
            this(false);
        }

        public Base32(boolean useHex) {
            this(0, null, useHex, 61);
        }

        public Base32(boolean useHex, byte padding) {
            this(0, null, useHex, padding);
        }

        public Base32(byte pad) {
            this(false, pad);
        }

        public Base32(int lineLength) {
            this(lineLength, CHUNK_SEPARATOR);
        }

        public Base32(int lineLength, byte[] lineSeparator) {
            this(lineLength, lineSeparator, false, 61);
        }

        public Base32(int lineLength, byte[] lineSeparator, boolean useHex) {
            this(lineLength, lineSeparator, useHex, 61);
        }

        public Base32(int lineLength, byte[] lineSeparator, boolean useHex, byte padding) {
            this(lineLength, lineSeparator, useHex, padding, DECODING_POLICY_DEFAULT);
        }

        public Base32(int lineLength, byte[] lineSeparator, boolean useHex, byte padding, CodecPolicy decodingPolicy) {
            super(5, 8, lineLength, lineSeparator == null ? 0 : lineSeparator.length, padding, decodingPolicy);
            if (useHex) {
                this.encodeTable = HEX_ENCODE_TABLE;
                this.decodeTable = HEX_DECODE_TABLE;
            } else {
                this.encodeTable = ENCODE_TABLE;
                this.decodeTable = DECODE_TABLE;
            }
            if (lineLength > 0) {
                if (lineSeparator == null) {
                    throw new IllegalArgumentException("lineLength " + lineLength + " > 0, but lineSeparator is null");
                }
                if (this.containsAlphabetOrPad(lineSeparator)) {
                    String sep = StringUtils.newStringUtf8(lineSeparator);
                    throw new IllegalArgumentException("lineSeparator must not contain Base32 characters: [" + sep + "]");
                }
                this.encodeSize = 8 + lineSeparator.length;
                this.lineSeparator = (byte[])lineSeparator.clone();
            } else {
                this.encodeSize = 8;
                this.lineSeparator = null;
            }
            this.decodeSize = this.encodeSize - 1;
            if (this.isInAlphabet(padding) || Character.isWhitespace(padding)) {
                throw new IllegalArgumentException("pad must not be in alphabet or whitespace");
            }
        }

        @Override
        void decode(byte[] input, int inPos, int inAvail, BaseNCodec.Context context) {
            if (context.eof) {
                return;
            }
            if (inAvail < 0) {
                context.eof = true;
            }
            for (int i = 0; i < inAvail; ++i) {
                byte result;
                byte b;
                if ((b = input[inPos++]) == this.pad) {
                    context.eof = true;
                    break;
                }
                byte[] buffer = this.ensureBufferSize(this.decodeSize, context);
                if (b < 0 || b >= this.decodeTable.length || (result = this.decodeTable[b]) < 0) continue;
                context.modulus = (context.modulus + 1) % 8;
                context.lbitWorkArea = (context.lbitWorkArea << 5) + (long)result;
                if (context.modulus != 0) continue;
                buffer[context.pos++] = (byte)(context.lbitWorkArea >> 32 & 0xFFL);
                buffer[context.pos++] = (byte)(context.lbitWorkArea >> 24 & 0xFFL);
                buffer[context.pos++] = (byte)(context.lbitWorkArea >> 16 & 0xFFL);
                buffer[context.pos++] = (byte)(context.lbitWorkArea >> 8 & 0xFFL);
                buffer[context.pos++] = (byte)(context.lbitWorkArea & 0xFFL);
            }
            if (context.eof && context.modulus > 0) {
                byte[] buffer = this.ensureBufferSize(this.decodeSize, context);
                switch (context.modulus) {
                    case 1: {
                        this.validateTrailingCharacters();
                    }
                    case 2: {
                        this.validateCharacter(3L, context);
                        buffer[context.pos++] = (byte)(context.lbitWorkArea >> 2 & 0xFFL);
                        break;
                    }
                    case 3: {
                        this.validateTrailingCharacters();
                        buffer[context.pos++] = (byte)(context.lbitWorkArea >> 7 & 0xFFL);
                        break;
                    }
                    case 4: {
                        this.validateCharacter(15L, context);
                        context.lbitWorkArea >>= 4;
                        buffer[context.pos++] = (byte)(context.lbitWorkArea >> 8 & 0xFFL);
                        buffer[context.pos++] = (byte)(context.lbitWorkArea & 0xFFL);
                        break;
                    }
                    case 5: {
                        this.validateCharacter(1L, context);
                        context.lbitWorkArea >>= 1;
                        buffer[context.pos++] = (byte)(context.lbitWorkArea >> 16 & 0xFFL);
                        buffer[context.pos++] = (byte)(context.lbitWorkArea >> 8 & 0xFFL);
                        buffer[context.pos++] = (byte)(context.lbitWorkArea & 0xFFL);
                        break;
                    }
                    case 6: {
                        this.validateTrailingCharacters();
                        context.lbitWorkArea >>= 6;
                        buffer[context.pos++] = (byte)(context.lbitWorkArea >> 16 & 0xFFL);
                        buffer[context.pos++] = (byte)(context.lbitWorkArea >> 8 & 0xFFL);
                        buffer[context.pos++] = (byte)(context.lbitWorkArea & 0xFFL);
                        break;
                    }
                    case 7: {
                        this.validateCharacter(7L, context);
                        context.lbitWorkArea >>= 3;
                        buffer[context.pos++] = (byte)(context.lbitWorkArea >> 24 & 0xFFL);
                        buffer[context.pos++] = (byte)(context.lbitWorkArea >> 16 & 0xFFL);
                        buffer[context.pos++] = (byte)(context.lbitWorkArea >> 8 & 0xFFL);
                        buffer[context.pos++] = (byte)(context.lbitWorkArea & 0xFFL);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Impossible modulus " + context.modulus);
                    }
                }
            }
        }

        @Override
        void encode(byte[] input, int inPos, int inAvail, BaseNCodec.Context context) {
            if (context.eof) {
                return;
            }
            if (inAvail < 0) {
                context.eof = true;
                if (0 == context.modulus && this.lineLength == 0) {
                    return;
                }
                byte[] buffer = this.ensureBufferSize(this.encodeSize, context);
                int savedPos = context.pos;
                switch (context.modulus) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 3) & 0x1F];
                        buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea << 2) & 0x1F];
                        buffer[context.pos++] = this.pad;
                        buffer[context.pos++] = this.pad;
                        buffer[context.pos++] = this.pad;
                        buffer[context.pos++] = this.pad;
                        buffer[context.pos++] = this.pad;
                        buffer[context.pos++] = this.pad;
                        break;
                    }
                    case 2: {
                        buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 11) & 0x1F];
                        buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 6) & 0x1F];
                        buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 1) & 0x1F];
                        buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea << 4) & 0x1F];
                        buffer[context.pos++] = this.pad;
                        buffer[context.pos++] = this.pad;
                        buffer[context.pos++] = this.pad;
                        buffer[context.pos++] = this.pad;
                        break;
                    }
                    case 3: {
                        buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 19) & 0x1F];
                        buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 14) & 0x1F];
                        buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 9) & 0x1F];
                        buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 4) & 0x1F];
                        buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea << 1) & 0x1F];
                        buffer[context.pos++] = this.pad;
                        buffer[context.pos++] = this.pad;
                        buffer[context.pos++] = this.pad;
                        break;
                    }
                    case 4: {
                        buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 27) & 0x1F];
                        buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 22) & 0x1F];
                        buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 17) & 0x1F];
                        buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 12) & 0x1F];
                        buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 7) & 0x1F];
                        buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 2) & 0x1F];
                        buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea << 3) & 0x1F];
                        buffer[context.pos++] = this.pad;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Impossible modulus " + context.modulus);
                    }
                }
                context.currentLinePos += context.pos - savedPos;
                if (this.lineLength > 0 && context.currentLinePos > 0) {
                    System.arraycopy(this.lineSeparator, 0, buffer, context.pos, this.lineSeparator.length);
                    context.pos += this.lineSeparator.length;
                }
            } else {
                for (int i = 0; i < inAvail; ++i) {
                    int b;
                    byte[] buffer = this.ensureBufferSize(this.encodeSize, context);
                    context.modulus = (context.modulus + 1) % 5;
                    if ((b = input[inPos++]) < 0) {
                        b += 256;
                    }
                    context.lbitWorkArea = (context.lbitWorkArea << 8) + (long)b;
                    if (0 != context.modulus) continue;
                    buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 35) & 0x1F];
                    buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 30) & 0x1F];
                    buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 25) & 0x1F];
                    buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 20) & 0x1F];
                    buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 15) & 0x1F];
                    buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 10) & 0x1F];
                    buffer[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 5) & 0x1F];
                    buffer[context.pos++] = this.encodeTable[(int)context.lbitWorkArea & 0x1F];
                    context.currentLinePos += 8;
                    if (this.lineLength <= 0 || this.lineLength > context.currentLinePos) continue;
                    System.arraycopy(this.lineSeparator, 0, buffer, context.pos, this.lineSeparator.length);
                    context.pos += this.lineSeparator.length;
                    context.currentLinePos = 0;
                }
            }
        }

        @Override
        public boolean isInAlphabet(byte octet) {
            return octet >= 0 && octet < this.decodeTable.length && this.decodeTable[octet] != -1;
        }

        private void validateCharacter(long emptyBitsMask, BaseNCodec.Context context) {
            if (this.isStrictDecoding() && (context.lbitWorkArea & emptyBitsMask) != 0L) {
                throw new IllegalArgumentException("Strict decoding: Last encoded character (before the paddings if any) is a valid base 32 alphabet but not a possible encoding. Expected the discarded bits from the character to be zero.");
            }
        }

        private void validateTrailingCharacters() {
            if (this.isStrictDecoding()) {
                throw new IllegalArgumentException("Strict decoding: Last encoded character(s) (before the paddings if any) are valid base 32 alphabet but not a possible encoding. Decoding requires either 2, 4, 5, or 7 trailing 5-bit characters to create bytes.");
            }
        }
    }

    static enum CodecPolicy {
        STRICT,
        LENIENT;

    }
}

