// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import static org.stellar.sdk.xdr.Constants.*;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;

// === xdr source ============================================================

//  struct DecoratedSignature
//  {
//      SignatureHint hint;  // last 4 bytes of the public key, used as a hint
//      Signature signature; // actual signature
//  };

//  ===========================================================================
public class DecoratedSignature implements XdrElement {
  public DecoratedSignature() {}

  private SignatureHint hint;

  public SignatureHint getHint() {
    return this.hint;
  }

  public void setHint(SignatureHint value) {
    this.hint = value;
  }

  private Signature signature;

  public Signature getSignature() {
    return this.signature;
  }

  public void setSignature(Signature value) {
    this.signature = value;
  }

  public static void encode(
      XdrDataOutputStream stream, DecoratedSignature encodedDecoratedSignature) throws IOException {
    SignatureHint.encode(stream, encodedDecoratedSignature.hint);
    Signature.encode(stream, encodedDecoratedSignature.signature);
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    encode(stream, this);
  }

  public static DecoratedSignature decode(XdrDataInputStream stream) throws IOException {
    DecoratedSignature decodedDecoratedSignature = new DecoratedSignature();
    decodedDecoratedSignature.hint = SignatureHint.decode(stream);
    decodedDecoratedSignature.signature = Signature.decode(stream);
    return decodedDecoratedSignature;
  }

  @Override
  public int hashCode() {
    return Objects.hash(this.hint, this.signature);
  }

  @Override
  public boolean equals(Object object) {
    if (!(object instanceof DecoratedSignature)) {
      return false;
    }

    DecoratedSignature other = (DecoratedSignature) object;
    return Objects.equals(this.hint, other.hint) && Objects.equals(this.signature, other.signature);
  }

  @Override
  public String toXdrBase64() throws IOException {
    return Base64Factory.getInstance().encodeToString(toXdrByteArray());
  }

  @Override
  public byte[] toXdrByteArray() throws IOException {
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
    encode(xdrDataOutputStream);
    return byteArrayOutputStream.toByteArray();
  }

  public static DecoratedSignature fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static DecoratedSignature fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  public static final class Builder {
    private SignatureHint hint;
    private Signature signature;

    public Builder hint(SignatureHint hint) {
      this.hint = hint;
      return this;
    }

    public Builder signature(Signature signature) {
      this.signature = signature;
      return this;
    }

    public DecoratedSignature build() {
      DecoratedSignature val = new DecoratedSignature();
      val.setHint(this.hint);
      val.setSignature(this.signature);
      return val;
    }
  }
}
