// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import static org.stellar.sdk.xdr.Constants.*;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;

// === xdr source ============================================================

//  struct Signer
//  {
//      SignerKey key;
//      uint32 weight; // really only need 1 byte
//  };

//  ===========================================================================
public class Signer implements XdrElement {
  public Signer() {}

  private SignerKey key;

  public SignerKey getKey() {
    return this.key;
  }

  public void setKey(SignerKey value) {
    this.key = value;
  }

  private Uint32 weight;

  public Uint32 getWeight() {
    return this.weight;
  }

  public void setWeight(Uint32 value) {
    this.weight = value;
  }

  public static void encode(XdrDataOutputStream stream, Signer encodedSigner) throws IOException {
    SignerKey.encode(stream, encodedSigner.key);
    Uint32.encode(stream, encodedSigner.weight);
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    encode(stream, this);
  }

  public static Signer decode(XdrDataInputStream stream) throws IOException {
    Signer decodedSigner = new Signer();
    decodedSigner.key = SignerKey.decode(stream);
    decodedSigner.weight = Uint32.decode(stream);
    return decodedSigner;
  }

  @Override
  public int hashCode() {
    return Objects.hash(this.key, this.weight);
  }

  @Override
  public boolean equals(Object object) {
    if (!(object instanceof Signer)) {
      return false;
    }

    Signer other = (Signer) object;
    return Objects.equals(this.key, other.key) && Objects.equals(this.weight, other.weight);
  }

  @Override
  public String toXdrBase64() throws IOException {
    return Base64Factory.getInstance().encodeToString(toXdrByteArray());
  }

  @Override
  public byte[] toXdrByteArray() throws IOException {
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
    encode(xdrDataOutputStream);
    return byteArrayOutputStream.toByteArray();
  }

  public static Signer fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static Signer fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  public static final class Builder {
    private SignerKey key;
    private Uint32 weight;

    public Builder key(SignerKey key) {
      this.key = key;
      return this;
    }

    public Builder weight(Uint32 weight) {
      this.weight = weight;
      return this;
    }

    public Signer build() {
      Signer val = new Signer();
      val.setKey(this.key);
      val.setWeight(this.weight);
      return val;
    }
  }
}
