// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import static org.stellar.sdk.xdr.Constants.*;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;

// === xdr source ============================================================

//  struct TTLEntry {
//      // Hash of the LedgerKey that is associated with this TTLEntry
//      Hash keyHash;
//      uint32 liveUntilLedgerSeq;
//  };

//  ===========================================================================
public class TTLEntry implements XdrElement {
  public TTLEntry() {}

  private Hash keyHash;

  public Hash getKeyHash() {
    return this.keyHash;
  }

  public void setKeyHash(Hash value) {
    this.keyHash = value;
  }

  private Uint32 liveUntilLedgerSeq;

  public Uint32 getLiveUntilLedgerSeq() {
    return this.liveUntilLedgerSeq;
  }

  public void setLiveUntilLedgerSeq(Uint32 value) {
    this.liveUntilLedgerSeq = value;
  }

  public static void encode(XdrDataOutputStream stream, TTLEntry encodedTTLEntry)
      throws IOException {
    Hash.encode(stream, encodedTTLEntry.keyHash);
    Uint32.encode(stream, encodedTTLEntry.liveUntilLedgerSeq);
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    encode(stream, this);
  }

  public static TTLEntry decode(XdrDataInputStream stream) throws IOException {
    TTLEntry decodedTTLEntry = new TTLEntry();
    decodedTTLEntry.keyHash = Hash.decode(stream);
    decodedTTLEntry.liveUntilLedgerSeq = Uint32.decode(stream);
    return decodedTTLEntry;
  }

  @Override
  public int hashCode() {
    return Objects.hash(this.keyHash, this.liveUntilLedgerSeq);
  }

  @Override
  public boolean equals(Object object) {
    if (!(object instanceof TTLEntry)) {
      return false;
    }

    TTLEntry other = (TTLEntry) object;
    return Objects.equals(this.keyHash, other.keyHash)
        && Objects.equals(this.liveUntilLedgerSeq, other.liveUntilLedgerSeq);
  }

  @Override
  public String toXdrBase64() throws IOException {
    return Base64Factory.getInstance().encodeToString(toXdrByteArray());
  }

  @Override
  public byte[] toXdrByteArray() throws IOException {
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
    encode(xdrDataOutputStream);
    return byteArrayOutputStream.toByteArray();
  }

  public static TTLEntry fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TTLEntry fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  public static final class Builder {
    private Hash keyHash;
    private Uint32 liveUntilLedgerSeq;

    public Builder keyHash(Hash keyHash) {
      this.keyHash = keyHash;
      return this;
    }

    public Builder liveUntilLedgerSeq(Uint32 liveUntilLedgerSeq) {
      this.liveUntilLedgerSeq = liveUntilLedgerSeq;
      return this;
    }

    public TTLEntry build() {
      TTLEntry val = new TTLEntry();
      val.setKeyHash(this.keyHash);
      val.setLiveUntilLedgerSeq(this.liveUntilLedgerSeq);
      return val;
    }
  }
}
