/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Operation;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;

public class AccountMergeOperation
extends Operation {
    @NonNull
    private final String destination;

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDestination(accountConverter.encode(this.destination));
        body.setDiscriminant(OperationType.ACCOUNT_MERGE);
        return body;
    }

    @NonNull
    @Generated
    public String getDestination() {
        return this.destination;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountMergeOperation)) {
            return false;
        }
        AccountMergeOperation other = (AccountMergeOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        return !(this$destination == null ? other$destination != null : !this$destination.equals(other$destination));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AccountMergeOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        return result;
    }

    @Generated
    private AccountMergeOperation(@NonNull String destination) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        this.destination = destination;
    }

    public static class Builder {
        private final String destination;
        private String sourceAccount;

        Builder(AccountConverter accountConverter, Operation.OperationBody op) {
            this.destination = accountConverter.decode(op.getDestination());
        }

        public Builder(String destination) {
            this.destination = destination;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this;
        }

        public AccountMergeOperation build() {
            AccountMergeOperation operation = new AccountMergeOperation(this.destination);
            if (this.sourceAccount != null) {
                operation.setSourceAccount(this.sourceAccount);
            }
            return operation;
        }
    }
}

