/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Operation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.AllowTrustOp;
import org.stellar.sdk.xdr.AssetCode;
import org.stellar.sdk.xdr.AssetCode12;
import org.stellar.sdk.xdr.AssetCode4;
import org.stellar.sdk.xdr.AssetType;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.TrustLineFlags;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrUnsignedInteger;

@Deprecated
public class AllowTrustOperation
extends Operation {
    @NonNull
    private final String trustor;
    @NonNull
    private final String assetCode;
    private final boolean authorize;
    private final boolean authorizeToMaintainLiabilities;

    public boolean getAuthorize() {
        return this.authorize;
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        AllowTrustOp op = new AllowTrustOp();
        op.setTrustor(StrKey.encodeToXDRAccountId(this.trustor));
        AssetCode asset = new AssetCode();
        if (this.assetCode.length() <= 4) {
            AssetCode4 assetCode4 = new AssetCode4();
            assetCode4.setAssetCode4(Util.paddedByteArray(this.assetCode, 4));
            asset.setDiscriminant(AssetType.ASSET_TYPE_CREDIT_ALPHANUM4);
            asset.setAssetCode4(assetCode4);
        } else {
            AssetCode12 assetCode12 = new AssetCode12();
            assetCode12.setAssetCode12(Util.paddedByteArray(this.assetCode, 12));
            asset.setDiscriminant(AssetType.ASSET_TYPE_CREDIT_ALPHANUM12);
            asset.setAssetCode12(assetCode12);
        }
        op.setAsset(asset);
        Uint32 flag = new Uint32();
        if (this.authorize) {
            flag.setUint32(new XdrUnsignedInteger(TrustLineFlags.AUTHORIZED_FLAG.getValue()));
        } else if (this.authorizeToMaintainLiabilities) {
            flag.setUint32(new XdrUnsignedInteger(TrustLineFlags.AUTHORIZED_TO_MAINTAIN_LIABILITIES_FLAG.getValue()));
        } else {
            flag.setUint32(new XdrUnsignedInteger(0));
        }
        op.setAuthorize(flag);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.ALLOW_TRUST);
        body.setAllowTrustOp(op);
        return body;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AllowTrustOperation)) {
            return false;
        }
        AllowTrustOperation other = (AllowTrustOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getAuthorize() != other.getAuthorize()) {
            return false;
        }
        if (this.isAuthorizeToMaintainLiabilities() != other.isAuthorizeToMaintainLiabilities()) {
            return false;
        }
        String this$trustor = this.getTrustor();
        String other$trustor = other.getTrustor();
        if (this$trustor == null ? other$trustor != null : !this$trustor.equals(other$trustor)) {
            return false;
        }
        String this$assetCode = this.getAssetCode();
        String other$assetCode = other.getAssetCode();
        return !(this$assetCode == null ? other$assetCode != null : !this$assetCode.equals(other$assetCode));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AllowTrustOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.getAuthorize() ? 79 : 97);
        result = result * 59 + (this.isAuthorizeToMaintainLiabilities() ? 79 : 97);
        String $trustor = this.getTrustor();
        result = result * 59 + ($trustor == null ? 43 : $trustor.hashCode());
        String $assetCode = this.getAssetCode();
        result = result * 59 + ($assetCode == null ? 43 : $assetCode.hashCode());
        return result;
    }

    @Generated
    private AllowTrustOperation(@NonNull String trustor, @NonNull String assetCode, boolean authorize, boolean authorizeToMaintainLiabilities) {
        if (trustor == null) {
            throw new NullPointerException("trustor is marked non-null but is null");
        }
        if (assetCode == null) {
            throw new NullPointerException("assetCode is marked non-null but is null");
        }
        this.trustor = trustor;
        this.assetCode = assetCode;
        this.authorize = authorize;
        this.authorizeToMaintainLiabilities = authorizeToMaintainLiabilities;
    }

    @NonNull
    @Generated
    public String getTrustor() {
        return this.trustor;
    }

    @NonNull
    @Generated
    public String getAssetCode() {
        return this.assetCode;
    }

    @Generated
    public boolean isAuthorizeToMaintainLiabilities() {
        return this.authorizeToMaintainLiabilities;
    }

    public static class Builder {
        private final String trustor;
        private final String assetCode;
        private final boolean authorize;
        private boolean authorizeToMaintainLiabilities;
        private String sourceAccount;

        Builder(AllowTrustOp op) {
            this.trustor = StrKey.encodeEd25519PublicKey(op.getTrustor());
            switch (op.getAsset().getDiscriminant()) {
                case ASSET_TYPE_CREDIT_ALPHANUM4: {
                    this.assetCode = new String(op.getAsset().getAssetCode4().getAssetCode4()).trim();
                    break;
                }
                case ASSET_TYPE_CREDIT_ALPHANUM12: {
                    this.assetCode = new String(op.getAsset().getAssetCode12().getAssetCode12()).trim();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown asset code");
                }
            }
            int flag = op.getAuthorize().getUint32().getNumber().intValue();
            if (flag == TrustLineFlags.AUTHORIZED_FLAG.getValue()) {
                this.authorize = true;
                this.authorizeToMaintainLiabilities = false;
            } else if (flag == TrustLineFlags.AUTHORIZED_TO_MAINTAIN_LIABILITIES_FLAG.getValue()) {
                this.authorize = false;
                this.authorizeToMaintainLiabilities = true;
            } else {
                if (flag != 0) {
                    throw new IllegalArgumentException("invalid authorize flag " + flag);
                }
                this.authorize = false;
                this.authorizeToMaintainLiabilities = false;
            }
        }

        public Builder(String trustor, String assetCode, boolean authorize) {
            this.trustor = trustor;
            this.assetCode = assetCode;
            this.authorize = authorize;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this;
        }

        public AllowTrustOperation build() {
            AllowTrustOperation operation = new AllowTrustOperation(this.trustor, this.assetCode, this.authorize, this.authorizeToMaintainLiabilities);
            if (this.sourceAccount != null) {
                operation.setSourceAccount(this.sourceAccount);
            }
            return operation;
        }
    }
}

