/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Asset;
import org.stellar.sdk.Operation;
import org.stellar.sdk.Price;
import org.stellar.sdk.xdr.CreatePassiveSellOfferOp;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;

public class CreatePassiveSellOfferOperation
extends Operation {
    @NonNull
    private final Asset selling;
    @NonNull
    private final Asset buying;
    @NonNull
    private final String amount;
    @NonNull
    private final Price price;

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        CreatePassiveSellOfferOp op = new CreatePassiveSellOfferOp();
        op.setSelling(this.selling.toXdr());
        op.setBuying(this.buying.toXdr());
        Int64 amount = new Int64();
        amount.setInt64(Operation.toXdrAmount(this.amount));
        op.setAmount(amount);
        op.setPrice(this.price.toXdr());
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.CREATE_PASSIVE_SELL_OFFER);
        body.setCreatePassiveSellOfferOp(op);
        return body;
    }

    @NonNull
    @Generated
    public Asset getSelling() {
        return this.selling;
    }

    @NonNull
    @Generated
    public Asset getBuying() {
        return this.buying;
    }

    @NonNull
    @Generated
    public String getAmount() {
        return this.amount;
    }

    @NonNull
    @Generated
    public Price getPrice() {
        return this.price;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreatePassiveSellOfferOperation)) {
            return false;
        }
        CreatePassiveSellOfferOperation other = (CreatePassiveSellOfferOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Asset this$selling = this.getSelling();
        Asset other$selling = other.getSelling();
        if (this$selling == null ? other$selling != null : !((Object)this$selling).equals(other$selling)) {
            return false;
        }
        Asset this$buying = this.getBuying();
        Asset other$buying = other.getBuying();
        if (this$buying == null ? other$buying != null : !((Object)this$buying).equals(other$buying)) {
            return false;
        }
        String this$amount = this.getAmount();
        String other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
            return false;
        }
        Price this$price = this.getPrice();
        Price other$price = other.getPrice();
        return !(this$price == null ? other$price != null : !((Object)this$price).equals(other$price));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreatePassiveSellOfferOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Asset $selling = this.getSelling();
        result = result * 59 + ($selling == null ? 43 : $selling.hashCode());
        Asset $buying = this.getBuying();
        result = result * 59 + ($buying == null ? 43 : $buying.hashCode());
        String $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
        Price $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        return result;
    }

    @Generated
    private CreatePassiveSellOfferOperation(@NonNull Asset selling, @NonNull Asset buying, @NonNull String amount, @NonNull Price price) {
        if (selling == null) {
            throw new NullPointerException("selling is marked non-null but is null");
        }
        if (buying == null) {
            throw new NullPointerException("buying is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (price == null) {
            throw new NullPointerException("price is marked non-null but is null");
        }
        this.selling = selling;
        this.buying = buying;
        this.amount = amount;
        this.price = price;
    }

    public static class Builder {
        private final Asset selling;
        private final Asset buying;
        private final String amount;
        private final Price price;
        private String sourceAccount;

        Builder(CreatePassiveSellOfferOp op) {
            this.selling = Asset.fromXdr(op.getSelling());
            this.buying = Asset.fromXdr(op.getBuying());
            this.amount = Operation.fromXdrAmount(op.getAmount().getInt64());
            this.price = Price.fromXdr(op.getPrice());
        }

        public Builder(@NonNull Asset selling, @NonNull Asset buying, @NonNull String amount, @NonNull Price price) {
            if (selling == null) {
                throw new NullPointerException("selling is marked non-null but is null");
            }
            if (buying == null) {
                throw new NullPointerException("buying is marked non-null but is null");
            }
            if (amount == null) {
                throw new NullPointerException("amount is marked non-null but is null");
            }
            if (price == null) {
                throw new NullPointerException("price is marked non-null but is null");
            }
            this.selling = selling;
            this.buying = buying;
            this.amount = amount;
            this.price = price;
        }

        public Builder(@NonNull Asset selling, @NonNull Asset buying, @NonNull String amount, @NonNull String price) {
            this(selling, buying, amount, Price.fromString(price));
            if (selling == null) {
                throw new NullPointerException("selling is marked non-null but is null");
            }
            if (buying == null) {
                throw new NullPointerException("buying is marked non-null but is null");
            }
            if (amount == null) {
                throw new NullPointerException("amount is marked non-null but is null");
            }
            if (price == null) {
                throw new NullPointerException("price is marked non-null but is null");
            }
        }

        public Builder setSourceAccount(@NonNull String sourceAccount) {
            if (sourceAccount == null) {
                throw new NullPointerException("sourceAccount is marked non-null but is null");
            }
            this.sourceAccount = sourceAccount;
            return this;
        }

        public CreatePassiveSellOfferOperation build() {
            CreatePassiveSellOfferOperation operation = new CreatePassiveSellOfferOperation(this.selling, this.buying, this.amount, this.price);
            if (this.sourceAccount != null) {
                operation.setSourceAccount(this.sourceAccount);
            }
            return operation;
        }
    }
}

