/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Operation;
import org.stellar.sdk.xdr.DataValue;
import org.stellar.sdk.xdr.ManageDataOp;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.String64;
import org.stellar.sdk.xdr.XdrString;

public class ManageDataOperation
extends Operation {
    private final String name;
    private final byte[] value;

    private ManageDataOperation(@NonNull String name, byte[] value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        this.value = value;
        if (new XdrString(this.name).getBytes().length > 64) {
            throw new IllegalArgumentException("name cannot exceed 64 bytes");
        }
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        ManageDataOp op = new ManageDataOp();
        String64 name = new String64();
        name.setString64(new XdrString(this.name));
        op.setDataName(name);
        if (this.value != null) {
            DataValue dataValue = new DataValue();
            dataValue.setDataValue(this.value);
            op.setDataValue(dataValue);
        }
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.MANAGE_DATA);
        body.setManageDataOp(op);
        return body;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public byte[] getValue() {
        return this.value;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ManageDataOperation)) {
            return false;
        }
        ManageDataOperation other = (ManageDataOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        return Arrays.equals(this.getValue(), other.getValue());
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ManageDataOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + Arrays.hashCode(this.getValue());
        return result;
    }

    public static class Builder {
        private final String name;
        private final byte[] value;
        private String sourceAccount;

        Builder(ManageDataOp op) {
            this.name = op.getDataName().getString64().toString();
            this.value = (byte[])(op.getDataValue() != null ? op.getDataValue().getDataValue() : null);
        }

        public Builder(@NonNull String name, byte[] value) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            this.value = value;
        }

        public Builder setSourceAccount(@NonNull String sourceAccount) {
            if (sourceAccount == null) {
                throw new NullPointerException("sourceAccount is marked non-null but is null");
            }
            this.sourceAccount = sourceAccount;
            return this;
        }

        public ManageDataOperation build() {
            ManageDataOperation operation = new ManageDataOperation(this.name, this.value);
            if (this.sourceAccount != null) {
                operation.setSourceAccount(this.sourceAccount);
            }
            return operation;
        }
    }
}

