/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Asset;
import org.stellar.sdk.Operation;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.PaymentOp;

public class PaymentOperation
extends Operation {
    @NonNull
    private final String destination;
    @NonNull
    private final Asset asset;
    @NonNull
    private final String amount;

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        PaymentOp op = new PaymentOp();
        op.setDestination(accountConverter.encode(this.destination));
        op.setAsset(this.asset.toXdr());
        Int64 amount = new Int64();
        amount.setInt64(Operation.toXdrAmount(this.amount));
        op.setAmount(amount);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.PAYMENT);
        body.setPaymentOp(op);
        return body;
    }

    @NonNull
    @Generated
    public String getDestination() {
        return this.destination;
    }

    @NonNull
    @Generated
    public Asset getAsset() {
        return this.asset;
    }

    @NonNull
    @Generated
    public String getAmount() {
        return this.amount;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentOperation)) {
            return false;
        }
        PaymentOperation other = (PaymentOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        Asset this$asset = this.getAsset();
        Asset other$asset = other.getAsset();
        if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
            return false;
        }
        String this$amount = this.getAmount();
        String other$amount = other.getAmount();
        return !(this$amount == null ? other$amount != null : !this$amount.equals(other$amount));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaymentOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        Asset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : $asset.hashCode());
        String $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
        return result;
    }

    @Generated
    private PaymentOperation(@NonNull String destination, @NonNull Asset asset, @NonNull String amount) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.destination = destination;
        this.asset = asset;
        this.amount = amount;
    }

    public static class Builder {
        private final String destination;
        private final Asset asset;
        private final String amount;
        private String sourceAccount;

        Builder(AccountConverter accountConverter, PaymentOp op) {
            this.destination = accountConverter.decode(op.getDestination());
            this.asset = Asset.fromXdr(op.getAsset());
            this.amount = Operation.fromXdrAmount(op.getAmount().getInt64());
        }

        public Builder(String destination, Asset asset, String amount) {
            this.destination = destination;
            this.asset = asset;
            this.amount = amount;
        }

        public Builder setSourceAccount(String account) {
            this.sourceAccount = account;
            return this;
        }

        public PaymentOperation build() {
            PaymentOperation operation = new PaymentOperation(this.destination, this.asset, this.amount);
            if (this.sourceAccount != null) {
                operation.setSourceAccount(this.sourceAccount);
            }
            return operation;
        }
    }
}

