/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.math.BigInteger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.stellar.sdk.xdr.ClaimPredicate;
import org.stellar.sdk.xdr.ClaimPredicateType;
import org.stellar.sdk.xdr.Duration;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.TimePoint;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrUnsignedHyperInteger;

public abstract class Predicate {
    private static List<Predicate> convertXDRPredicates(ClaimPredicate[] predicates) {
        ArrayList<Predicate> list = new ArrayList<Predicate>();
        for (ClaimPredicate p : predicates) {
            list.add(Predicate.fromXdr(p));
        }
        return list;
    }

    public static Predicate fromXdr(ClaimPredicate xdr) {
        switch (xdr.getDiscriminant()) {
            case CLAIM_PREDICATE_UNCONDITIONAL: {
                return new Unconditional();
            }
            case CLAIM_PREDICATE_AND: {
                return new And(Predicate.convertXDRPredicates(xdr.getAndPredicates()));
            }
            case CLAIM_PREDICATE_OR: {
                return new Or(Predicate.convertXDRPredicates(xdr.getOrPredicates()));
            }
            case CLAIM_PREDICATE_NOT: {
                return new Not(Predicate.fromXdr(xdr.getNotPredicate()));
            }
            case CLAIM_PREDICATE_BEFORE_RELATIVE_TIME: {
                return new RelBefore(xdr.getRelBefore().getInt64());
            }
            case CLAIM_PREDICATE_BEFORE_ABSOLUTE_TIME: {
                return new AbsBefore(xdr.getAbsBefore().getInt64());
            }
        }
        throw new IllegalArgumentException("Unknown asset type " + xdr.getDiscriminant());
    }

    public abstract boolean equals(Object var1);

    public abstract ClaimPredicate toXdr();

    public static class Unconditional
    extends Predicate {
        @Override
        public ClaimPredicate toXdr() {
            ClaimPredicate xdr = new ClaimPredicate();
            xdr.setDiscriminant(ClaimPredicateType.CLAIM_PREDICATE_UNCONDITIONAL);
            return xdr;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Unconditional)) {
                return false;
            }
            Unconditional other = (Unconditional)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Unconditional;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class And
    extends Predicate {
        private final List<Predicate> inner;

        @Override
        public ClaimPredicate toXdr() {
            ClaimPredicate xdr = new ClaimPredicate();
            xdr.setDiscriminant(ClaimPredicateType.CLAIM_PREDICATE_AND);
            ClaimPredicate[] xdrInner = new ClaimPredicate[this.inner.size()];
            for (int i = 0; i < this.inner.size(); ++i) {
                xdrInner[i] = this.inner.get(i).toXdr();
            }
            xdr.setAndPredicates(xdrInner);
            return xdr;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof And)) {
                return false;
            }
            And other = (And)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Predicate> this$inner = this.getInner();
            List<Predicate> other$inner = other.getInner();
            return !(this$inner == null ? other$inner != null : !((Object)this$inner).equals(other$inner));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof And;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Predicate> $inner = this.getInner();
            result = result * 59 + ($inner == null ? 43 : ((Object)$inner).hashCode());
            return result;
        }

        @Generated
        public And(List<Predicate> inner) {
            this.inner = inner;
        }

        @Generated
        public List<Predicate> getInner() {
            return this.inner;
        }
    }

    public static class Or
    extends Predicate {
        private final List<Predicate> inner;

        @Override
        public ClaimPredicate toXdr() {
            ClaimPredicate xdr = new ClaimPredicate();
            xdr.setDiscriminant(ClaimPredicateType.CLAIM_PREDICATE_OR);
            ClaimPredicate[] xdrInner = new ClaimPredicate[this.inner.size()];
            for (int i = 0; i < this.inner.size(); ++i) {
                xdrInner[i] = this.inner.get(i).toXdr();
            }
            xdr.setOrPredicates(xdrInner);
            return xdr;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Or)) {
                return false;
            }
            Or other = (Or)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Predicate> this$inner = this.getInner();
            List<Predicate> other$inner = other.getInner();
            return !(this$inner == null ? other$inner != null : !((Object)this$inner).equals(other$inner));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Or;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Predicate> $inner = this.getInner();
            result = result * 59 + ($inner == null ? 43 : ((Object)$inner).hashCode());
            return result;
        }

        @Generated
        public Or(List<Predicate> inner) {
            this.inner = inner;
        }

        @Generated
        public List<Predicate> getInner() {
            return this.inner;
        }
    }

    public static class Not
    extends Predicate {
        private final Predicate inner;

        @Override
        public ClaimPredicate toXdr() {
            ClaimPredicate xdr = new ClaimPredicate();
            xdr.setDiscriminant(ClaimPredicateType.CLAIM_PREDICATE_NOT);
            xdr.setNotPredicate(this.inner.toXdr());
            return xdr;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Not)) {
                return false;
            }
            Not other = (Not)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Predicate this$inner = this.getInner();
            Predicate other$inner = other.getInner();
            return !(this$inner == null ? other$inner != null : !((Object)this$inner).equals(other$inner));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Not;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Predicate $inner = this.getInner();
            result = result * 59 + ($inner == null ? 43 : $inner.hashCode());
            return result;
        }

        @Generated
        public Not(Predicate inner) {
            this.inner = inner;
        }

        @Generated
        public Predicate getInner() {
            return this.inner;
        }
    }

    public static class RelBefore
    extends Predicate {
        private final Duration duration;

        public RelBefore(long secondsSinceClose) {
            this(new Duration(new Uint64(new XdrUnsignedHyperInteger(secondsSinceClose))));
        }

        public long getSecondsSinceClose() {
            return this.duration.getDuration().getUint64().getNumber().longValue();
        }

        @Override
        public ClaimPredicate toXdr() {
            ClaimPredicate xdr = new ClaimPredicate();
            xdr.setDiscriminant(ClaimPredicateType.CLAIM_PREDICATE_BEFORE_RELATIVE_TIME);
            xdr.setRelBefore(new Int64(this.duration.getDuration().getUint64().getNumber().longValue()));
            return xdr;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RelBefore)) {
                return false;
            }
            RelBefore other = (RelBefore)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Duration this$duration = this.duration;
            Duration other$duration = other.duration;
            return !(this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RelBefore;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Duration $duration = this.duration;
            result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
            return result;
        }

        @Generated
        public RelBefore(Duration duration) {
            this.duration = duration;
        }
    }

    public static class AbsBefore
    extends Predicate {
        private final TimePoint timePoint;

        public AbsBefore(TimePoint timePoint) {
            this.timePoint = timePoint;
        }

        public AbsBefore(long epochSeconds) {
            this(new TimePoint(new Uint64(new XdrUnsignedHyperInteger(epochSeconds))));
        }

        public AbsBefore(BigInteger epochSeconds) {
            this(new TimePoint(new Uint64(new XdrUnsignedHyperInteger(epochSeconds))));
        }

        public BigInteger getTimestampSeconds() {
            return this.timePoint.getTimePoint().getUint64().getNumber();
        }

        public Instant getDate() {
            Instant instantMax = Instant.MAX;
            if (this.getTimestampSeconds().compareTo(BigInteger.valueOf(instantMax.getEpochSecond())) > 0) {
                return instantMax;
            }
            return Instant.ofEpochSecond(this.timePoint.getTimePoint().getUint64().getNumber().longValue());
        }

        @Override
        public ClaimPredicate toXdr() {
            ClaimPredicate xdr = new ClaimPredicate();
            xdr.setDiscriminant(ClaimPredicateType.CLAIM_PREDICATE_BEFORE_ABSOLUTE_TIME);
            xdr.setAbsBefore(new Int64(this.timePoint.getTimePoint().getUint64().getNumber().longValue()));
            return xdr;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AbsBefore)) {
                return false;
            }
            AbsBefore other = (AbsBefore)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TimePoint this$timePoint = this.timePoint;
            TimePoint other$timePoint = other.timePoint;
            return !(this$timePoint == null ? other$timePoint != null : !((Object)this$timePoint).equals(other$timePoint));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AbsBefore;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TimePoint $timePoint = this.timePoint;
            result = result * 59 + ($timePoint == null ? 43 : ((Object)$timePoint).hashCode());
            return result;
        }
    }
}

