/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import org.stellar.sdk.Base32;
import org.stellar.sdk.Base32Factory;
import org.stellar.sdk.FormatException;
import org.stellar.sdk.SignedPayloadSigner;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.CryptoKeyType;
import org.stellar.sdk.xdr.MuxedAccount;
import org.stellar.sdk.xdr.PublicKey;
import org.stellar.sdk.xdr.PublicKeyType;
import org.stellar.sdk.xdr.SignerKey;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrUnsignedHyperInteger;

public class StrKey {
    private static final byte[] b32Table = StrKey.decodingTable();
    private static final Base32 base32Codec = Base32Factory.getInstance();

    public static String encodeEd25519PublicKey(byte[] data) {
        char[] encoded = StrKey.encodeCheck(VersionByte.ACCOUNT_ID, data);
        return String.valueOf(encoded);
    }

    public static byte[] decodeEd25519PublicKey(String data) {
        return StrKey.decodeCheck(VersionByte.ACCOUNT_ID, data.toCharArray());
    }

    public static char[] encodeEd25519SecretSeed(byte[] data) {
        return StrKey.encodeCheck(VersionByte.SEED, data);
    }

    public static byte[] decodeEd25519SecretSeed(char[] data) {
        return StrKey.decodeCheck(VersionByte.SEED, data);
    }

    public static String encodePreAuthTx(byte[] data) {
        char[] encoded = StrKey.encodeCheck(VersionByte.PRE_AUTH_TX, data);
        return String.valueOf(encoded);
    }

    public static byte[] decodePreAuthTx(String data) {
        return StrKey.decodeCheck(VersionByte.PRE_AUTH_TX, data.toCharArray());
    }

    public static String encodeSha256Hash(byte[] data) {
        char[] encoded = StrKey.encodeCheck(VersionByte.SHA256_HASH, data);
        return String.valueOf(encoded);
    }

    public static byte[] decodeSha256Hash(String data) {
        return StrKey.decodeCheck(VersionByte.SHA256_HASH, data.toCharArray());
    }

    public static String encodeSignedPayload(SignedPayloadSigner signedPayloadSigner) {
        try {
            SignerKey.SignerKeyEd25519SignedPayload xdrPayloadSigner = new SignerKey.SignerKeyEd25519SignedPayload();
            xdrPayloadSigner.setPayload(signedPayloadSigner.getPayload());
            xdrPayloadSigner.setEd25519(signedPayloadSigner.getSignerAccountId().getAccountID().getEd25519());
            ByteArrayOutputStream record = new ByteArrayOutputStream();
            xdrPayloadSigner.encode(new XdrDataOutputStream(record));
            char[] encoded = StrKey.encodeCheck(VersionByte.SIGNED_PAYLOAD, record.toByteArray());
            return String.valueOf(encoded);
        }
        catch (Exception ex) {
            throw new FormatException(ex.getMessage());
        }
    }

    public static SignedPayloadSigner decodeSignedPayload(String data) {
        try {
            byte[] signedPayloadRaw = StrKey.decodeCheck(VersionByte.SIGNED_PAYLOAD, data.toCharArray());
            SignerKey.SignerKeyEd25519SignedPayload xdrPayloadSigner = SignerKey.SignerKeyEd25519SignedPayload.fromXdrByteArray(signedPayloadRaw);
            return new SignedPayloadSigner(xdrPayloadSigner.getEd25519().getUint256(), xdrPayloadSigner.getPayload());
        }
        catch (Exception ex) {
            throw new FormatException(ex.getMessage());
        }
    }

    public static String encodeContract(byte[] data) {
        char[] encoded = StrKey.encodeCheck(VersionByte.CONTRACT, data);
        return String.valueOf(encoded);
    }

    public static byte[] decodeContract(String data) {
        return StrKey.decodeCheck(VersionByte.CONTRACT, data.toCharArray());
    }

    static String encodeEd25519PublicKey(AccountID accountID) {
        char[] encoded = StrKey.encodeCheck(VersionByte.ACCOUNT_ID, accountID.getAccountID().getEd25519().getUint256());
        return String.valueOf(encoded);
    }

    static String encodeStellarMuxedAccount(MuxedAccount muxedAccount) {
        switch (muxedAccount.getDiscriminant()) {
            case KEY_TYPE_MUXED_ED25519: {
                return String.valueOf(StrKey.encodeCheck(VersionByte.MUXED, StrKey.getMuxedEd25519AccountBytes(muxedAccount)));
            }
            case KEY_TYPE_ED25519: {
                return String.valueOf(StrKey.encodeCheck(VersionByte.ACCOUNT_ID, muxedAccount.getEd25519().getUint256()));
            }
        }
        throw new IllegalArgumentException("invalid discriminant");
    }

    static AccountID muxedAccountToAccountId(MuxedAccount account) {
        AccountID aid = new AccountID();
        PublicKey key = new PublicKey();
        key.setDiscriminant(PublicKeyType.PUBLIC_KEY_TYPE_ED25519);
        if (account.getDiscriminant().equals(CryptoKeyType.KEY_TYPE_ED25519)) {
            key.setEd25519(account.getEd25519());
        } else if (account.getDiscriminant().equals(CryptoKeyType.KEY_TYPE_MUXED_ED25519)) {
            key.setEd25519(account.getMed25519().getEd25519());
        } else {
            throw new IllegalArgumentException("invalid muxed account type: " + account.getDiscriminant());
        }
        aid.setAccountID(key);
        return aid;
    }

    static AccountID encodeToXDRAccountId(String data) {
        AccountID accountID = new AccountID();
        PublicKey publicKey = new PublicKey();
        publicKey.setDiscriminant(PublicKeyType.PUBLIC_KEY_TYPE_ED25519);
        try {
            publicKey.setEd25519(Uint256.fromXdrByteArray(StrKey.decodeEd25519PublicKey(data)));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid address: " + data, e);
        }
        accountID.setAccountID(publicKey);
        return accountID;
    }

    static MuxedAccount encodeToXDRMuxedAccount(String data) {
        MuxedAccount muxed = new MuxedAccount();
        if (data.isEmpty()) {
            throw new IllegalArgumentException("address is empty");
        }
        switch (StrKey.decodeVersionByte(data).ordinal()) {
            case 0: {
                muxed.setDiscriminant(CryptoKeyType.KEY_TYPE_ED25519);
                try {
                    muxed.setEd25519(Uint256.fromXdrByteArray(StrKey.decodeEd25519PublicKey(data)));
                    break;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("invalid address: " + data, e);
                }
            }
            case 1: {
                XdrDataInputStream input = new XdrDataInputStream(new ByteArrayInputStream(StrKey.decodeCheck(VersionByte.MUXED, data.toCharArray())));
                muxed.setDiscriminant(CryptoKeyType.KEY_TYPE_MUXED_ED25519);
                MuxedAccount.MuxedAccountMed25519 med = new MuxedAccount.MuxedAccountMed25519();
                try {
                    med.setEd25519(Uint256.decode(input));
                    med.setId(new Uint64(XdrUnsignedHyperInteger.decode(input)));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("invalid address: " + data, e);
                }
                muxed.setMed25519(med);
                break;
            }
            default: {
                throw new FormatException("Version byte is invalid");
            }
        }
        return muxed;
    }

    static VersionByte decodeVersionByte(String data) {
        byte[] dataBytes = data.getBytes(StandardCharsets.UTF_8);
        byte[] decoded = StrKey.base32decode(dataBytes);
        byte decodedVersionByte = decoded[0];
        Optional<VersionByte> versionByteOptional = VersionByte.findByValue(decodedVersionByte);
        if (!versionByteOptional.isPresent()) {
            throw new FormatException("Version byte is invalid");
        }
        return versionByteOptional.get();
    }

    static boolean isValidEd25519PublicKey(String accountID) {
        try {
            StrKey.decodeEd25519PublicKey(accountID);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static boolean isValidContract(String contractId) {
        try {
            StrKey.decodeContract(contractId);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static char[] encodeCheck(VersionByte versionByte, byte[] data) {
        try {
            ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
            outputStream2.write(versionByte.getValue());
            outputStream2.write(data);
            byte[] payload = outputStream2.toByteArray();
            byte[] checksum = StrKey.calculateChecksum(payload);
            outputStream2.write(checksum);
            byte[] unencoded = outputStream2.toByteArray();
            byte[] encodedBytes = base32Codec.encode(unencoded);
            byte[] unpaddedEncodedBytes = StrKey.removeBase32Padding(encodedBytes);
            char[] charsEncoded = StrKey.bytesToChars(unpaddedEncodedBytes);
            if (VersionByte.SEED != versionByte) {
                return charsEncoded;
            }
            Arrays.fill(unencoded, (byte)0);
            Arrays.fill(payload, (byte)0);
            Arrays.fill(checksum, (byte)0);
            Arrays.fill(encodedBytes, (byte)0);
            Arrays.fill(unpaddedEncodedBytes, (byte)0);
            return charsEncoded;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    static byte[] decodeCheck(VersionByte versionByte, char[] encoded) {
        byte leftoverBitsMask;
        byte lastChar;
        byte decodedLastChar;
        byte[] bytes = new byte[encoded.length];
        for (int i = 0; i < encoded.length; ++i) {
            bytes[i] = (byte)encoded[i];
        }
        if (bytes.length < 5) {
            throw new IllegalArgumentException("Encoded char array must have a length of at least 5.");
        }
        int leftoverBits = bytes.length * 5 % 8;
        if (leftoverBits >= 5) {
            throw new IllegalArgumentException("Encoded char array has leftover character.");
        }
        if (leftoverBits > 0 && ((decodedLastChar = b32Table[lastChar = bytes[bytes.length - 1]]) & (leftoverBitsMask = (byte)(15 >> 4 - leftoverBits))) != 0) {
            throw new IllegalArgumentException("Unused bits should be set to 0.");
        }
        byte[] decoded = StrKey.base32decode(bytes);
        byte decodedVersionByte = decoded[0];
        byte[] payload = Arrays.copyOfRange(decoded, 0, decoded.length - 2);
        byte[] data = Arrays.copyOfRange(payload, 1, payload.length);
        byte[] checksum = Arrays.copyOfRange(decoded, decoded.length - 2, decoded.length);
        if (decodedVersionByte != versionByte.getValue()) {
            throw new FormatException("Version byte is invalid");
        }
        byte[] expectedChecksum = StrKey.calculateChecksum(payload);
        if (!Arrays.equals(expectedChecksum, checksum)) {
            throw new FormatException("Checksum invalid");
        }
        if (VersionByte.SEED.getValue() == decodedVersionByte) {
            Arrays.fill(bytes, (byte)0);
            Arrays.fill(decoded, (byte)0);
            Arrays.fill(payload, (byte)0);
        }
        return data;
    }

    private static byte[] calculateChecksum(byte[] bytes) {
        int crc = 0;
        int i = 0;
        for (int count = bytes.length; count > 0; --count) {
            int code = crc >>> 8 & 0xFF;
            code ^= bytes[i++] & 0xFF;
            code ^= code >>> 4;
            crc = crc << 8 & 0xFFFF;
            crc ^= code;
            code = code << 5 & 0xFFFF;
            crc ^= code;
            code = code << 7 & 0xFFFF;
            crc ^= code;
        }
        return new byte[]{(byte)crc, (byte)(crc >>> 8)};
    }

    private static byte[] decodingTable() {
        byte[] table = new byte[256];
        for (int i = 0; i < 256; ++i) {
            table[i] = -1;
        }
        String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
        for (int i = 0; i < alphabet.length(); ++i) {
            table[alphabet.charAt((int)i)] = (byte)i;
        }
        return table;
    }

    private static byte[] getMuxedEd25519AccountBytes(MuxedAccount muxedAccount) {
        byte[] accountBytes = muxedAccount.getMed25519().getEd25519().getUint256();
        byte[] idBytes = muxedAccount.getMed25519().getId().getUint64().getNumber().toByteArray();
        byte[] idPaddedBytes = new byte[8];
        int idNumBytesToCopy = Math.min(idBytes.length, 8);
        int idCopyStartIndex = idBytes.length - idNumBytesToCopy;
        System.arraycopy(idBytes, idCopyStartIndex, idPaddedBytes, 8 - idNumBytesToCopy, idNumBytesToCopy);
        byte[] result = new byte[accountBytes.length + idPaddedBytes.length];
        System.arraycopy(accountBytes, 0, result, 0, accountBytes.length);
        System.arraycopy(idPaddedBytes, 0, result, accountBytes.length, idPaddedBytes.length);
        return result;
    }

    private static byte[] removeBase32Padding(byte[] data) {
        int unpaddedLength;
        for (unpaddedLength = data.length; unpaddedLength > 0 && data[unpaddedLength - 1] == 61; --unpaddedLength) {
        }
        return Arrays.copyOf(data, unpaddedLength);
    }

    private static char[] bytesToChars(byte[] data) {
        char[] chars = new char[data.length];
        for (int i = 0; i < data.length; ++i) {
            chars[i] = (char)(data[i] & 0xFF);
        }
        return chars;
    }

    private static byte[] base32decode(byte[] data) {
        if (!StrKey.isInAlphabet(data)) {
            throw new IllegalArgumentException("Invalid base32 encoded string");
        }
        return base32Codec.decode(data);
    }

    private static boolean isInAlphabet(byte[] arrayOctet) {
        for (byte octet : arrayOctet) {
            if (octet >= 0 && octet < b32Table.length && b32Table[octet] != -1) continue;
            return false;
        }
        return true;
    }

    static enum VersionByte {
        ACCOUNT_ID(48),
        MUXED(96),
        SEED(-112),
        PRE_AUTH_TX(-104),
        SHA256_HASH(-72),
        SIGNED_PAYLOAD(120),
        CONTRACT(16);

        private final byte value;

        private VersionByte(byte value) {
            this.value = value;
        }

        public static Optional<VersionByte> findByValue(byte value) {
            for (VersionByte versionByte : VersionByte.values()) {
                if (value != versionByte.value) continue;
                return Optional.of(versionByte);
            }
            return Optional.empty();
        }

        public int getValue() {
            return this.value;
        }
    }
}

