/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.math.BigInteger;
import lombok.Generated;
import org.stellar.sdk.TransactionPreconditions;
import org.stellar.sdk.xdr.TimePoint;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrUnsignedHyperInteger;

public final class TimeBounds {
    private final BigInteger minTime;
    private final BigInteger maxTime;

    public TimeBounds(BigInteger minTime, BigInteger maxTime) {
        if (minTime.compareTo(XdrUnsignedHyperInteger.MIN_VALUE) < 0 || minTime.compareTo(XdrUnsignedHyperInteger.MAX_VALUE) > 0) {
            throw new IllegalArgumentException("minTime must be between 0 and 2^64-1");
        }
        if (maxTime.compareTo(XdrUnsignedHyperInteger.MIN_VALUE) < 0 || maxTime.compareTo(XdrUnsignedHyperInteger.MAX_VALUE) > 0) {
            throw new IllegalArgumentException("maxTime must be between 0 and 2^64-1");
        }
        if (!TransactionPreconditions.TIMEOUT_INFINITE.equals(maxTime) && minTime.compareTo(maxTime) > 0) {
            throw new IllegalArgumentException("minTime must be <= maxTime");
        }
        this.minTime = minTime;
        this.maxTime = maxTime;
    }

    public TimeBounds(long minTime, long maxTime) {
        this(BigInteger.valueOf(minTime), BigInteger.valueOf(maxTime));
    }

    public static TimeBounds expiresAfter(long timeout2) {
        long now = System.currentTimeMillis() / 1000L;
        long endTime = now + timeout2;
        return new TimeBounds(0L, endTime);
    }

    public static TimeBounds fromXdr(org.stellar.sdk.xdr.TimeBounds timeBounds) {
        if (timeBounds == null) {
            return null;
        }
        return new TimeBounds(timeBounds.getMinTime().getTimePoint().getUint64().getNumber(), timeBounds.getMaxTime().getTimePoint().getUint64().getNumber());
    }

    public org.stellar.sdk.xdr.TimeBounds toXdr() {
        org.stellar.sdk.xdr.TimeBounds timeBounds = new org.stellar.sdk.xdr.TimeBounds();
        TimePoint minTime = new TimePoint();
        TimePoint maxTime = new TimePoint();
        Uint64 minTimeTemp = new Uint64();
        Uint64 maxTimeTemp = new Uint64();
        minTimeTemp.setUint64(new XdrUnsignedHyperInteger(this.minTime));
        maxTimeTemp.setUint64(new XdrUnsignedHyperInteger(this.maxTime));
        minTime.setTimePoint(minTimeTemp);
        maxTime.setTimePoint(maxTimeTemp);
        timeBounds.setMinTime(minTime);
        timeBounds.setMaxTime(maxTime);
        return timeBounds;
    }

    @Generated
    public BigInteger getMinTime() {
        return this.minTime;
    }

    @Generated
    public BigInteger getMaxTime() {
        return this.maxTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeBounds)) {
            return false;
        }
        TimeBounds other = (TimeBounds)o;
        BigInteger this$minTime = this.getMinTime();
        BigInteger other$minTime = other.getMinTime();
        if (this$minTime == null ? other$minTime != null : !((Object)this$minTime).equals(other$minTime)) {
            return false;
        }
        BigInteger this$maxTime = this.getMaxTime();
        BigInteger other$maxTime = other.getMaxTime();
        return !(this$maxTime == null ? other$maxTime != null : !((Object)this$maxTime).equals(other$maxTime));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $minTime = this.getMinTime();
        result = result * 59 + ($minTime == null ? 43 : ((Object)$minTime).hashCode());
        BigInteger $maxTime = this.getMaxTime();
        result = result * 59 + ($maxTime == null ? 43 : ((Object)$maxTime).hashCode());
        return result;
    }
}

