/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import lombok.NonNull;
import org.stellar.sdk.AbstractTransaction;
import org.stellar.sdk.Account;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.FormatException;
import org.stellar.sdk.Memo;
import org.stellar.sdk.Network;
import org.stellar.sdk.NoNetworkSelectedException;
import org.stellar.sdk.Operation;
import org.stellar.sdk.SorobanDataBuilder;
import org.stellar.sdk.TimeBounds;
import org.stellar.sdk.Transaction;
import org.stellar.sdk.TransactionBuilderAccount;
import org.stellar.sdk.TransactionPreconditions;
import org.stellar.sdk.xdr.SorobanTransactionData;

public class TransactionBuilder {
    private final TransactionBuilderAccount sourceAccount;
    private final AccountConverter accountConverter;
    private Memo memo;
    private final List<Operation> operations;
    private Long baseFee;
    private final Network network;
    @NonNull
    private TransactionPreconditions preconditions;
    private SorobanTransactionData sorobanData;
    private BigInteger txTimeout;
    public static Function<TransactionBuilderAccount, Long> IncrementedSequenceNumberFunc = TransactionBuilderAccount::getIncrementedSequenceNumber;

    public TransactionBuilder(@NonNull AccountConverter accountConverter, @NonNull TransactionBuilderAccount sourceAccount, @NonNull Network network) {
        if (accountConverter == null) {
            throw new NullPointerException("accountConverter is marked non-null but is null");
        }
        if (sourceAccount == null) {
            throw new NullPointerException("sourceAccount is marked non-null but is null");
        }
        if (network == null) {
            throw new NullPointerException("network is marked non-null but is null");
        }
        this.accountConverter = accountConverter;
        this.sourceAccount = sourceAccount;
        this.network = network;
        this.operations = new ArrayList<Operation>();
        this.preconditions = TransactionPreconditions.builder().build();
    }

    public TransactionBuilder(TransactionBuilderAccount sourceAccount, Network network) {
        this(AccountConverter.enableMuxed(), sourceAccount, network);
    }

    public TransactionBuilder(Transaction transaction) {
        AbstractTransaction abstractTransaction;
        try {
            abstractTransaction = Transaction.fromEnvelopeXdr(transaction.getAccountConverter(), transaction.toEnvelopeXdrBase64(), transaction.getNetwork());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!(abstractTransaction instanceof Transaction)) {
            throw new RuntimeException("TransactionBuilder can only be used to rebuild a Transaction");
        }
        Transaction tx = (Transaction)abstractTransaction;
        this.sourceAccount = new Account(tx.getSourceAccount(), tx.getSequenceNumber() - 1L);
        this.accountConverter = tx.accountConverter;
        this.memo = tx.getMemo();
        this.operations = Arrays.asList(tx.getOperations());
        this.baseFee = tx.getFee() / (long)tx.getOperations().length;
        this.network = tx.getNetwork();
        this.preconditions = tx.getPreconditions();
        this.sorobanData = tx.getSorobanData();
    }

    public int getOperationsCount() {
        return this.operations.size();
    }

    public TransactionBuilder addOperation(@NonNull Operation operation) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        this.operations.add(operation);
        return this;
    }

    public TransactionBuilder addOperations(@NonNull Collection<Operation> operations) {
        if (operations == null) {
            throw new NullPointerException("operations is marked non-null but is null");
        }
        this.operations.addAll(operations);
        return this;
    }

    public TransactionBuilder addPreconditions(@NonNull TransactionPreconditions preconditions) {
        if (preconditions == null) {
            throw new NullPointerException("preconditions is marked non-null but is null");
        }
        this.preconditions = preconditions;
        return this;
    }

    public TransactionBuilder addMemo(@NonNull Memo memo) {
        if (memo == null) {
            throw new NullPointerException("memo is marked non-null but is null");
        }
        if (this.memo != null) {
            throw new RuntimeException("Memo has been already added.");
        }
        this.memo = memo;
        return this;
    }

    public TransactionBuilder setTimeout(BigInteger timeout2) {
        if (timeout2.compareTo(BigInteger.ZERO) < 0) {
            throw new RuntimeException("timeout cannot be negative");
        }
        this.txTimeout = timeout2;
        return this;
    }

    public TransactionBuilder setTimeout(long timeout2) {
        return this.setTimeout(BigInteger.valueOf(timeout2));
    }

    public TransactionBuilder setBaseFee(long baseFee) {
        if (baseFee < 100L) {
            throw new IllegalArgumentException("baseFee cannot be smaller than the BASE_FEE (100): " + baseFee);
        }
        this.baseFee = baseFee;
        return this;
    }

    public Transaction build() {
        if (this.preconditions.getTimeBounds() != null && this.txTimeout != null) {
            throw new IllegalArgumentException("Can not set both TransactionPreconditions.timeBounds and timeout.");
        }
        if (this.txTimeout != null) {
            BigInteger maxTime = !TransactionPreconditions.TIMEOUT_INFINITE.equals(this.txTimeout) ? this.txTimeout.add(BigInteger.valueOf(System.currentTimeMillis() / 1000L)) : TransactionPreconditions.TIMEOUT_INFINITE;
            this.preconditions = this.preconditions.toBuilder().timeBounds(new TimeBounds(BigInteger.ZERO, maxTime)).build();
        }
        this.preconditions.isValid();
        if (this.baseFee == null) {
            throw new FormatException("baseFee has to be set. you must call setBaseFee().");
        }
        if (this.network == null) {
            throw new NoNetworkSelectedException();
        }
        long sequenceNumber = this.sourceAccount.getIncrementedSequenceNumber();
        Operation[] operations = new Operation[this.operations.size()];
        operations = this.operations.toArray(operations);
        Transaction transaction = new Transaction(this.accountConverter, this.sourceAccount.getAccountId(), (long)operations.length * this.baseFee, sequenceNumber, operations, this.memo, this.preconditions, this.sorobanData, this.network);
        this.sourceAccount.setSequenceNumber(sequenceNumber);
        return transaction;
    }

    public TransactionBuilder setSorobanData(SorobanTransactionData sorobanData) {
        this.sorobanData = new SorobanDataBuilder(sorobanData).build();
        return this;
    }

    public TransactionBuilder setSorobanData(String sorobanData) {
        this.sorobanData = new SorobanDataBuilder(sorobanData).build();
        return this;
    }
}

